<?php

namespace App\Http\Controllers\User;

use App\Enums\Trade\TradeOutcome;
use App\Enums\Trade\TradeType;
use App\Enums\Transaction\WalletType;
use App\Enums\Transaction\Type;
use App\Enums\Transaction\Source;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\View\View;
use App\Models\Competition;
use App\Models\CompetitionParticipants;
use App\Models\Wallet;
use App\Models\Transaction;
use App\Models\RewardRanking;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use App\Services\Trade\CryptoCurrencyService;
use App\Services\Trade\ParameterService;
use App\Services\Trade\ActivityLogService;

class CompetitionController extends Controller
{
	public function __construct(
        protected CryptoCurrencyService $cryptoCurrencyService,		
        protected ParameterService $parameterService,
        protected ActivityLogService $activityLogService,
    ){
    }
	
    public function index(): View
    {
        $setTitle = "Competition";
		$now = Carbon::now();
		$liveCompetition = Competition::where('start_time', '<=', $now)
					->where('end_time', '>=', $now)
					->with(['participants'])
					->get();
		$upcomingCompetition = Competition::where('start_time', '>', $now)
					->with(['participants'])
					->get();
		$pastCompetition = Competition::where('end_time', '<', $now)
					->with(['participants'])
					->where(function (Builder $query) {
						$query->whereHas('participants', function (Builder $q) {							
							$q->where('user_id', Auth::id());							
						});
					})
					->get();
		$myCompetition = Competition::where('start_time', '<=', $now)
					->where('end_time', '>=', $now)
					->with(['participants'])
					->where(function (Builder $query) {
						$query->whereHas('participants', function (Builder $q) {							
							$q->where('user_id', Auth::id());							
						});
					})
					->get();
		//dd($pastCompetition);			
        return view('user.competition.index', compact(
            'setTitle',
            'liveCompetition',
            'upcomingCompetition',
            'pastCompetition',
            'myCompetition',
        ));
    }
    /** public function competition_details($id): View
    {
        $setTitle = "Competition Details";
		$now = Carbon::now();
		$competition_details = Competition::where('id', $id)
					->with(['participants.user_details'])
                   ->first();
		$cryptoCurrency = $this->cryptoCurrencyService->getActiveCryptoCurrencyByPaginate(); //getActiveCryptoCurrency		
        $parameters = $this->parameterService->activeParameter();
		$userId = (int)Auth::id();
		$tradeLogs = $this->activityLogService->getByUserCompetition($userId, TradeType::VIRTUAL_TRADE, false, $id);
		
		
		//Leaderboard start
		$competitionTradeLogs = $this->activityLogService->getByCompetition(TradeType::VIRTUAL_TRADE, $id);
		
		foreach($competition_details->participants as $k=>$user){
			$log[$k]['participant'] = $user->user_details->first_name.' '.$user->user_details->last_name;
			$log[$k]['trade_completed'] = $competitionTradeLogs->where('user_id', $user->user_details->id)->whereIn('outcome', [TradeOutcome::WIN->value, TradeOutcome::LOSE->value, TradeOutcome::DRAW->value])->count();
			$log[$k]['total_profit'] = $competitionTradeLogs->where('user_id', $user->user_details->id)->where('outcome', TradeOutcome::WIN->value)->count();
			$log[$k]['total_loss'] = $competitionTradeLogs->where('user_id', $user->user_details->id)->where('outcome', TradeOutcome::LOSE->value)->count();
			//if($log[$k]['trade_completed'] == $log[$k]['total_profit']){
			//	dd(25);
			//}
			$total_no_of_trades = $competition_details->trade_amount / $competition_details->per_trade_amount;
			$trade_ref_value = 100/$total_no_of_trades;
			if($log[$k]['trade_completed'] == $log[$k]['total_profit']){				
				$log[$k]['profit_loss_ratio'] = $trade_ref_value;
				$log[$k]['efficiency_ratio'] = ($log[$k]['trade_completed']*$trade_ref_value) * $log[$k]['profit_loss_ratio'];
				if(($log[$k]['total_profit'] == 0 && $log[$k]['total_loss'] == 0)){				
					$log[$k]['profit_loss_ratio'] = 0;
					$log[$k]['efficiency_ratio'] = 0;
					
				}
			}else if($log[$k]['total_profit'] > 1 && $log[$k]['total_loss'] == 0){
				$log[$k]['profit_loss_ratio'] = $trade_ref_value*$log[$k]['total_profit'];				
				// $log[$k]['efficiency_ratio'] = 100;
				$log[$k]['efficiency_ratio'] = ($trade_ref_value*$total_no_of_trades)*$log[$k]['total_profit'];
				
			}else if(($log[$k]['total_profit'] == 0) || ($log[$k]['total_loss'] == 0) || ($log[$k]['total_profit'] == 0 && $log[$k]['total_loss'] == 0)){				
				$log[$k]['profit_loss_ratio'] = 0;
				$log[$k]['efficiency_ratio'] = 0;
				
			}else{
				$profit_loss_ratio_val = $log[$k]['total_profit'] / $log[$k]['total_loss'];
				$log[$k]['profit_loss_ratio'] = number_format($profit_loss_ratio_val, 2);
				$log[$k]['efficiency_ratio'] = number_format((($log[$k]['trade_completed']*$trade_ref_value) * $profit_loss_ratio_val), 2);
				
			}
		}
		array_multisort(array_column($log, 'efficiency_ratio'), SORT_DESC, $log);
		
		// Initialize rank counter
			$currentRank = 1;
			$previousPoints = null;
			foreach($log as $k=>$val){
				if ($previousPoints !== null && $val['efficiency_ratio'] !== $previousPoints) {
					$currentRank = $currentRank + 1;
				}
				$log[$k]['rank'] = $currentRank;
				$previousPoints = $val['efficiency_ratio'];
			}
		$leaderboard = $log;
		// dd($log);
		
		
        return view('user.competition.details', compact(
            'setTitle',
            'competition_details',
            'cryptoCurrency',
            'parameters',
            'tradeLogs',
            'leaderboard',
        ));
    } */
    
    
    public function competition_details($id): View
	{
		$setTitle = "Competition Details";
		$now = Carbon::now();
		$competition_details = Competition::where('id', $id)
					->with(['participants.user_details'])
					->first();
		$cryptoCurrency = $this->cryptoCurrencyService->getActiveCryptoCurrencyByPaginate();
		$parameters = $this->parameterService->activeParameter();
		$userId = (int)Auth::id();
		$tradeLogs = $this->activityLogService->getByUserCompetition($userId, TradeType::VIRTUAL_TRADE, false, $id);

		// Leaderboard start
		$competitionTradeLogs = $this->activityLogService->getByCompetition(TradeType::VIRTUAL_TRADE, $id);

		$log = [];
		foreach ($competition_details->participants as $k => $user) {
			$userId = $user->user_details->id;
			$log[$k]['participant_id'] = $user->user_details->id;
			$log[$k]['participant'] = $user->user_details->first_name . ' ' . $user->user_details->last_name;
			$log[$k]['trade_completed'] = $competitionTradeLogs->where('user_id', $userId)->whereIn('outcome', [TradeOutcome::WIN->value, TradeOutcome::LOSE->value, TradeOutcome::DRAW->value])->count();
			$log[$k]['total_profit'] = $competitionTradeLogs->where('user_id', $userId)->where('outcome', TradeOutcome::WIN->value)->count();
			$log[$k]['total_loss'] = $competitionTradeLogs->where('user_id', $userId)->where('outcome', TradeOutcome::LOSE->value)->count();

			$total_no_of_trades = $competition_details->trade_amount / $competition_details->per_trade_amount;
			$trade_ref_value = 100 / $total_no_of_trades;

			if ($log[$k]['trade_completed'] > 0) {
				$profit_loss_ratio = $log[$k]['total_loss'] > 0 ? $log[$k]['total_profit'] / $log[$k]['total_loss'] : $log[$k]['total_profit'];
				$log[$k]['profit_loss_ratio'] = number_format($profit_loss_ratio, 2);
				$log[$k]['efficiency_ratio'] = number_format(($log[$k]['trade_completed'] * $trade_ref_value) * $profit_loss_ratio, 2);
			} else {
				$log[$k]['profit_loss_ratio'] = 0;
				$log[$k]['efficiency_ratio'] = 0;
			}
			$log[$k]['reward'] = $user->reward_amt > 0 ?  $user->reward_amt : '-';
		}

		// Sort by efficiency ratio in descending order
		array_multisort(array_column($log, 'efficiency_ratio'), SORT_DESC, $log);

		// Initialize rank counter and assign ranks
		$currentRank = 1;
		$previousPoints = null;
		foreach ($log as $k => $val) {
			if ($previousPoints !== null && $val['efficiency_ratio'] !== $previousPoints) {
				$currentRank++;
			}

			$log[$k]['rank'] = $currentRank;
			if($competition_details->is_rewarded == 0){
				$log[$k]['reward'] = '-';
			}
			$previousPoints = $val['efficiency_ratio'];
		}
		$leaderboard = $log;
		
		//Add reward to the user
		if($competition_details->is_rewarded == 0){
			if(Carbon::now() > $competition_details->end_time){
				// dd($log);
				foreach($log as $participant){
					$rank = $participant['rank'];
					if (!isset($rankCounters[$rank])) {
						$rankCounters[$rank] = 0;
					}
					$rankCounters[$rank]++;
				}
				
				$reward_details = RewardRanking::where('participant_count', $competition_details->ranking_id)->first(); //Reward details
				// $reward_total_amount = count($competition_details->participants)*$competition_details->entry_fee; //Total amount of competition
				$reward_total_amount = $competition_details->prize_pool_amt; //Total amount of competition
				// dd($reward_total_amount);
				foreach($log as $k=>$val){
					$get_rank_member = $rankCounters[$val['rank']]; //Get the total user who have same rank
					if(isset($reward_details->rank_value)){
						$reward_details_rank = json_decode($reward_details->rank_value, true);
						// dd($reward_details_rank);
						$rankToFind = $val['rank'];
						$percentage = null;
						$defaultPercentage = 0;
						$percentage = $defaultPercentage;
						$found = false;
						foreach ($reward_details_rank as $data) {
							$from = (int) $data['rank_from'];
							$to = (int) $data['rank_to'];
							$percentage = (int) $data['percentage'];
							
							if($from != $to && $from < $to){
								$range = range($from, $to);
								foreach($range as $val){
									$percentage = (int) $data['percentage']/count($range);
								}
							}
							if ($rankToFind >= $from && $rankToFind <= $to) {
								// $percentage = (int) $data['percentage'];
								$percentage = $percentage;
								$found = true;
								break;
							}
							// dd($percentage);
						}
						if (!$found) {
							$percentage = $defaultPercentage;
						}
						/*if($reward_details_rank){
							
						}*/
						
						$per_user_reward_percent = $percentage/$get_rank_member; //reward percent for evry user
						
						// dd(json_decode($reward_details->rank_value, true));
						// dd($get_rank_member);
						$log[$k]['reward'] = $reward_total_amount*($per_user_reward_percent/100);
						
						//Update competitin Participate reward amount
						CompetitionParticipants::where('user_id', $val['participant_id'])->where('competition_id', $id)->update([
							'reward_amt' => $log[$k]['reward'],
						]);
						Competition::where('id', $id)->update([
							'is_rewarded' => 1,
						]);
					}
				}
				// dd($rankCounters);
				$leaderboard = $log;
			}
		}
		return view('user.competition.details', compact(
			'setTitle',
			'competition_details',
			'cryptoCurrency',
			'parameters',
			'tradeLogs',
			'leaderboard',
		));
	}


    public function competition_details_ajax(Request $request)
    {
		if(isset($request->competition_id) && $request->competition_id != ''){
			$data = Competition::where('id', $request->competition_id)->first();
			return response(['status' => 200, 'data' => $data]);
		}else{
			return response(['error' => 'Something wrong!', 'status' => 400]);
		}
    }
    public function competition_details_availability(Request $request)
    {
		if(isset($request->competition_id) && $request->competition_id != ''){
			$data = Competition::where('id', $request->competition_id)->first();
			$currentDate = Carbon::now();
			$startDate = Carbon::parse($data->start_time);
			$endDate = Carbon::parse($data->end_time);
			if($currentDate->between($startDate, $endDate)){
				$participant_counter = CompetitionParticipants::where('competition_id', $request->competition_id)->count();
				if($participant_counter >= $data->number_of_participants){
					return response(['error' => 'Sorry, the competition is already full. No more participant are allowed.', 'status' => 400]);
				}else{					
					return response(['status' => 200, 'data' => $data]);
				}
			}else{
				return response(['error' => 'Competition time is over', 'status' => 400]);
			}
		}else{
			return response(['error' => 'Something wrong!', 'status' => 400]);
		}
    }
    public function join_competition(Request $request)
    {
		if(isset($request->competition_id) && $request->competition_id != ''){
			$data = Competition::where('id', $request->competition_id)->first();
			$currentDate = Carbon::now();
			$startDate = Carbon::parse($data->start_time);
			$endDate = Carbon::parse($data->end_time);
			if($currentDate->between($startDate, $endDate)){
				$participant_counter = CompetitionParticipants::where('competition_id', $request->competition_id)->count();
				if($participant_counter >= $data->number_of_participants){
					return response(['error' => 'Sorry, the competition is already full. No more participant are allowed.', 'status' => 400]);
				}else{
					$userId = (int)Auth::id();
					$existing_balance = Wallet::where('user_id', $userId)->first();
					
					if($existing_balance->primary_balance < $data->entry_fee){
						return response(['error' => 'Insufficient funds. Your Primary Balance account: '.getCurrencySymbol() . number_format($existing_balance->primary_balance, 0).'.', 'status' => 400]);
					}else{
						$add = new CompetitionParticipants;
						$add->competition_id 	= $request->competition_id;
						$add->user_id 			= $userId;
						$add->competition_amt 	= $data->entry_fee;
						$add->competition_trade_amt 	= $data->trade_amount;
						$add->reward_amt 	= '0.00000000';
						$add->created_at 		= Carbon::now();
						$add->updated_at 		= null;
						if($add->save()){
							Wallet::where('user_id', $userId)->update([
								'primary_balance'=>floatval($existing_balance->primary_balance) - floatval($data->entry_fee),
								'virtual_trade_balance'=>floatval($existing_balance->virtual_trade_balance) + floatval($data->trade_amount),
							]); //Update competition trade wallet balance.
							
							Transaction::create([
								'user_id' => $userId,
								'amount' => $data->entry_fee,
								'post_balance' => floatval($existing_balance->primary_balance) - floatval($data->entry_fee),
								'charge' => 0,
								'trx' => getTrx(),
								'type' => Type::MINUS->value,
								'wallet_type' => WalletType::PRIMARY,
								'source' => Source::VIRTUAL_TRADE,
								'details' => 'Join competition at '.getCurrencySymbol().$data->entry_fee,
							]);
						}
						return response(['success' => 'Successfully participation in the competition.', 'status' => 200, 'redirect_route' => route('user.competition.competition-details', $request->competition_id)]);
					}
				}
			}else{
				return response(['error' => 'Competition time is over', 'status' => 400]);
			}
		}else{
			
		}
    }
}
