<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('competitions', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->timestamp('start_time')->nullable();
            $table->timestamp('end_time')->nullable();
            $table->decimal('prize_pool_amt', 28, 8)->default(0);
            $table->decimal('entry_fee', 28, 8)->default(0);
            $table->decimal('trade_amount', 28, 8)->default(0);
            $table->decimal('per_trade_amount', 28, 8)->default(0);
            $table->integer('number_of_participants');
            $table->integer('trade_expiry_time')->nullable();
            $table->integer('ranking_id')->nullable();
            $table->tinyInteger('is_rewarded')->default(0)->comment('0=Not rewarded, 1=Rewarded');
            $table->binary('rules')->nullable();
            $table->tinyInteger('status')->default(1)->comment('1=Active, 0=Inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('competitions');
    }
};
