<div class="market-widget mb-4 dark--card">
    <div class="card--title">
        <h5><?php echo e(__('BINARY PREDICT')); ?></h5>
    </div>
    <form method="POST" action="<?php echo e(route('user.trade.store', $crypto->id)); ?>">
        <?php echo csrf_field(); ?>

        <!-- Hidden input for trade type -->
        <input type="hidden" value="<?php echo e(request()->routeIs('user.trade.practice') ? \App\Enums\Trade\TradeType::PRACTICE->value : \App\Enums\Trade\TradeType::TRADE->value); ?>" name="type">

        <!-- Amount input field -->
        <div class="input-single">
            
            <?php
                $applyBinaryTradeCommissions = $setting->binary_trade_set;
                
                // Generate a random percentage between 30 and 50
                $randomPercentage = rand(30, 50) / 100;
                // Calculate the amount using the random percentage
                $calculatedAmount = $tradeBalance * $randomPercentage;
            ?>
        
            <?php if($applyBinaryTradeCommissions): ?>
            <label for="amount" hidden><?php echo e(__('Amount')); ?></label>

                <!-- Read-only input field if binary trade commissions are applied -->
                <input type="hidden" id="amount" name="amount" value="<?php echo e(old('amount', $calculatedAmount)); ?>" placeholder="0.00" required readonly>
            <?php else: ?>
            <label for="amount"><?php echo e(__('Amount')); ?></label>
                <!-- Editable input field if binary trade commissions are not applied -->
                <input type="text" id="amount" name="amount" value="<?php echo e(old('amount')); ?>" placeholder="0.00" required>
            <?php endif; ?>
        </div>

        <!-- Expiry Time -->
        <div class="input-single">
            <label for="parameter"><?php echo e(__('Expiry Time')); ?></label>
            <div class="toggle-buttons">
                <?php $__currentLoopData = $parameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="btn-toggle">
                        <input type="radio" name="parameter_id" value="<?php echo e($parameter->id); ?>" required>
                        <span><?php echo e($parameter->time . ' ' . \App\Enums\Trade\TradeParameterUnit::getName($parameter->unit)); ?></span>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Profit Card -->
     

        <!-- Submit Buttons -->
        <div class="d-flex justify-content-center align-items-center gap-3">
            <button type="submit" name="volume" value="<?php echo e(\App\Enums\Trade\TradeVolume::HIGH->value); ?>" class="i-btn btn--md btn--success capsuled w-100">
                <?php echo e(__(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::HIGH->value))); ?> <i class="bi bi-arrow-up"></i>
            </button>
            <button type="submit" name="volume" value="<?php echo e(\App\Enums\Trade\TradeVolume::LOW->value); ?>" class="i-btn btn--md btn--danger capsuled w-100">
                <?php echo e(__(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::LOW->value))); ?> <i class="bi bi-arrow-down"></i>
            </button>
        </div>
    </form>
</div>





<style>
    .toggle-buttons {
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
    }

    .btn-toggle {
        background-color: rgba(234, 125, 24, 0.4);
        color: white;
        border-radius: 3px;
        padding: 3px 3px;
        cursor: pointer;
        user-select: none;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    .btn-toggle input {
        display: none;
    }

    .btn-toggle span {
        display: block;
    }

    .btn-toggle input:checked + span {
        background-color: #fe710d;
    }

    /* Mobile responsiveness */
    @media (max-width: 768px) {
        .btn-toggle {
            flex: 1 0 30%; /* Adjust width as needed */
            text-align: center;
            padding: 10px;
        }

        .input-single input, .input-single select {
            width: 100%;
            padding: 10px;
        }

        .d-flex.justify-content-center.align-items-center.gap-3 {
            flex-direction: column;
            gap: 10px;
        }

        .i-btn {
            width: 100%;
            padding: 10px;
        }
    }
</style>
<?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/partials/trade/binary-trade.blade.php ENDPATH**/ ?>