<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <div class="row">
            <div class="col-lg-12">
                <?php if($matrixLog): ?>
                    <div class="i-card-sm mb-4">
                        <h4 class="title"><?php echo e(__('Enrolled Information')); ?></h4>
                        <div class="row g-3 row-cols-xl-4 row-cols-lg-4 row-cols-md-4 row-cols-sm-2 row-cols-1">
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Initiated At')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e(showDateTime($matrixLog->created_at)); ?></h5>
                                </div>
                            </div>
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Trx')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e($matrixLog->trx); ?></h5>
                                </div>
                            </div>
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Enrolled To')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e($matrixLog->name); ?></h5>
                                </div>
                            </div>
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Subscribed Amount')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->price)); ?></h5>
                                </div>
                            </div>
                           
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Buddy Referral Reward')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->referral_commissions)); ?></h5>
                                </div>
                            </div>
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Stage Referral Rewards')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->level_commissions)); ?></h5>
                                </div>
                            </div>
                            <div class="col">
                                <div class="i-card-sm p-3 primary--light shadow-none p-3">
                                    <p class="fs-15"><?php echo e(__('Enrollment Status')); ?></p>
                                    <h5 class="title-sm mb-0"><?php echo e(\App\Enums\Matrix\InvestmentStatus::getName($matrixLog->status)); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($matrixLog && $matrixLog->status == 1): ?>
                    <div class="i-card-sm p-3 primary--light shadow-none p-3">
                        <p class="fs-15 text-center"><?php echo e(__('You have already subscribed, congratulations and all the best for your journey!')); ?></p>
                    </div>
                <?php else: ?>
                    <div class="i-card-sm">
                        <div class="card-body">
                            <div class="row align-items-center gy-4">
                                <?php echo $__env->make('user.partials.matrix.plan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>







<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/matrix/index.blade.php ENDPATH**/ ?>