<?php

namespace App\Http\Controllers\Admin;

use App\Enums\Trade\TradeOutcome;
use App\Enums\Trade\TradeType;
use App\Enums\Transaction\WalletType;
use App\Enums\Transaction\Source;
use App\Http\Controllers\Controller;
use App\Http\Requests\CompetitionRequest;
use App\Models\Competition;
use App\Models\RewardRanking;
use App\Models\CompetitionParticipants;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;
use Carbon\Carbon;
use App\Services\Trade\ParameterService;
use App\Services\Trade\ActivityLogService;
use App\Services\Payment\TransactionService;
use App\Services\UserService;
use App\Services\Payment\WalletService;



class CompetitionController extends Controller
{
	public function __construct(	
        protected ParameterService $parameterService,
        protected ActivityLogService $activityLogService,
        protected TransactionService $transactionService,
        protected UserService $userService,
        protected WalletService  $walletService,
    ){
    }
	
    public function index(): View
    {
        $setTitle = __('admin.competition.page_title.competition');

        $competitions = Competition::query()->paginate(getPaginate());
        return view('admin.competition.index', compact(
            'setTitle',
            'competitions'
        ));
    }
    /**
     * @return View
     */
    public function create(): View
    {
        $setTitle = __('admin.competition.page_title.create');
		$parameters = $this->parameterService->activeParameter();
		$rankings = RewardRanking::get();
        return view('admin.competition.create', compact('setTitle', 'parameters', 'rankings'));
    }

    /**
     * @param CompetitionRequest $request
     * @return RedirectResponse
     */
    public function store(CompetitionRequest $request): RedirectResponse
    {
		//$date = explode(" - ", $request->input('competition_start_end'));
		Competition::create([
			'title' => $request->input('title'),
			'start_time' => showDateTime($request->input('competition_start'), 'Y-m-d H:i:s'),
			'end_time' => showDateTime($request->input('competition_end'), 'Y-m-d H:i:s'),
			'prize_pool_amt' => $request->input('prize_pool_amt'),
			'entry_fee' => $request->input('entry_fee'),
			'trade_amount' => $request->input('trade_amount'),
			'per_trade_amount' => $request->input('per_trade_amount'),
			'number_of_participants' => $request->input('number_of_participants'),
			'rules' => $request->input('rules'),
			'status' => $request->input('status'),
			'trade_expiry_time' => $request->input('trade_expiry_time'),
			'ranking_id' => $request->input('ranking_id'),
		]);
        return back()->with('notify', [['success', __('admin.competition.notify.create.success')]]);
    }

    public function edit(int|string $id): View
    {
        $setTitle = __('admin.competition.page_title.update');

        $competition = Competition::find($id);
		$parameters = $this->parameterService->activeParameter();
		$rankings = RewardRanking::get();
		if($competition){
			return view('admin.competition.edit', compact('setTitle', 'competition', 'parameters', 'rankings'));
		}else{
			abort(404);
		}
    }
	
    public function update(CompetitionRequest $request, int|string $id): RedirectResponse
    {
        /*$withdrawGateway = $this->gatewayService->findById($id);
        if(blank($withdrawGateway)) abort(404);

        $params = $this->gatewayService->prepParams($request);

        if(is_null(Arr::get($params, 'file'))){
            Arr::set($params, 'file', $withdrawGateway->file);
        }

        $withdrawGateway->update($params);
        return back()->with('notify', [['success', __('admin.competition.notify.update.success')]]);*/
		
		$competition = Competition::find($id);
		if(!$competition){
			abort(404);
		}
		
		//$date = explode(" - ", $request->input('competition_start_end'));
        $competition->title = $request->input('title');
		$competition->start_time = showDateTime($request->input('competition_start'), 'Y-m-d H:i:s');
		$competition->end_time = showDateTime($request->input('competition_end'), 'Y-m-d H:i:s');
		$competition->prize_pool_amt = $request->input('prize_pool_amt');
		$competition->entry_fee = $request->input('entry_fee');
		$competition->trade_amount = $request->input('trade_amount');
		$competition->per_trade_amount = $request->input('per_trade_amount');
		$competition->number_of_participants = $request->input('number_of_participants');
		$competition->rules = $request->input('rules');
		$competition->status = $request->input('status');
		$competition->trade_expiry_time = $request->input('trade_expiry_time');
		$competition->ranking_id = $request->input('ranking_id');
        $competition->save();
        return back()->with('notify', [['success', __('admin.competition.notify.update.success')]]);
    }
	
	public function competition_details($id): View
    {
        $setTitle = "Competition Details";
		$now = Carbon::now();
		$competition_details = Competition::where('id', $id)
					->with(['participants.user_details'])
                   ->first();
        $parameters = $this->parameterService->activeParameter();
		$tradeLogs = $this->activityLogService->getByCompetition(TradeType::VIRTUAL_TRADE, $id);
		
		
		//Leaderboard start
		$competitionTradeLogs = $tradeLogs;
		
		$log = [];
		// dd($competition_details->participants);
		foreach($competition_details->participants as $k=>$user){
			$log[$k]['participant_id'] = $user->user_details->id;
			$log[$k]['participant'] = $user->user_details->first_name.' '.$user->user_details->last_name;
			$log[$k]['trade_completed'] = $competitionTradeLogs->where('user_id', $user->user_details->id)->whereIn('outcome', [TradeOutcome::WIN->value, TradeOutcome::LOSE->value, TradeOutcome::DRAW->value])->count();
			$log[$k]['total_profit'] = $competitionTradeLogs->where('user_id', $user->user_details->id)->where('outcome', TradeOutcome::WIN->value)->count();
			$log[$k]['total_loss'] = $competitionTradeLogs->where('user_id', $user->user_details->id)->where('outcome', TradeOutcome::LOSE->value)->count();
			
			/*$total_no_of_trades = $competition_details->trade_amount / $competition_details->per_trade_amount;
			$trade_ref_value = 100/$total_no_of_trades;
			if($log[$k]['trade_completed'] == $log[$k]['total_profit']){				
				$log[$k]['profit_loss_ratio'] = $trade_ref_value;
				$log[$k]['efficiency_ratio'] = ($log[$k]['trade_completed']*$trade_ref_value) * $log[$k]['profit_loss_ratio'];
				if(($log[$k]['total_profit'] == 0 && $log[$k]['total_loss'] == 0)){				
					$log[$k]['profit_loss_ratio'] = 0;
					$log[$k]['efficiency_ratio'] = 0;
					
				}
			}else if($log[$k]['total_profit'] > 1 && $log[$k]['total_loss'] == 0){
				$log[$k]['profit_loss_ratio'] = $trade_ref_value*$log[$k]['total_profit'];				
				// $log[$k]['efficiency_ratio'] = 100;
				$log[$k]['efficiency_ratio'] = ($trade_ref_value*$total_no_of_trades)*$log[$k]['total_profit'];
				
			}else if(($log[$k]['total_profit'] == 0) || ($log[$k]['total_loss'] == 0) || ($log[$k]['total_profit'] == 0 && $log[$k]['total_loss'] == 0)){				
				$log[$k]['profit_loss_ratio'] = 0;
				$log[$k]['efficiency_ratio'] = 0;
				
			}else{
				$profit_loss_ratio_val = $log[$k]['total_profit'] / $log[$k]['total_loss'];
				$log[$k]['profit_loss_ratio'] = number_format($profit_loss_ratio_val, 2);
				$log[$k]['efficiency_ratio'] = number_format((($log[$k]['trade_completed']*$trade_ref_value) * $profit_loss_ratio_val), 2);
				
			}*/
			$total_no_of_trades = $competition_details->trade_amount / $competition_details->per_trade_amount;
			$trade_ref_value = 100 / $total_no_of_trades;

			if ($log[$k]['trade_completed'] > 0) {
				$profit_loss_ratio = $log[$k]['total_loss'] > 0 ? $log[$k]['total_profit'] / $log[$k]['total_loss'] : $log[$k]['total_profit'];
				$log[$k]['profit_loss_ratio'] = number_format($profit_loss_ratio, 2);
				$log[$k]['efficiency_ratio'] = number_format(($log[$k]['trade_completed'] * $trade_ref_value) * $profit_loss_ratio, 2);
			} else {
				$log[$k]['profit_loss_ratio'] = 0;
				$log[$k]['efficiency_ratio'] = 0;
			}
			$log[$k]['reward'] = $user->reward_amt > 0 ?  $user->reward_amt : '-';
		}
		array_multisort(array_column($log, 'efficiency_ratio'), SORT_DESC, $log);
		
		// Initialize rank counter
			$currentRank = 1;
			$previousPoints = null;
			foreach($log as $k=>$val){
				if ($previousPoints !== null && $val['efficiency_ratio'] !== $previousPoints) {
					$currentRank++;
				}
				$log[$k]['rank'] = $currentRank;
				if($competition_details->is_rewarded == 0){
					$log[$k]['reward'] = '-';
				}
				$previousPoints = $val['efficiency_ratio'];
			}
		$leaderboard = $log;
		// dd($log);
		
	//Add reward to the user
		if($competition_details->is_rewarded == 0){
			if(Carbon::now() > $competition_details->end_time){
				// dd($log);
				foreach($log as $participant){
					$rank = $participant['rank'];
					if (!isset($rankCounters[$rank])) {
						$rankCounters[$rank] = 0;
					}
					$rankCounters[$rank]++;
				}
				
				$reward_details = RewardRanking::where('participant_count', $competition_details->ranking_id)->first(); //Reward details
				// $reward_total_amount = count($competition_details->participants)*$competition_details->entry_fee; //Total amount of competition
				$reward_total_amount = $competition_details->prize_pool_amt; //Total amount of competition
				foreach($log as $k=>$val){
					$get_rank_member = $rankCounters[$val['rank']]; //Get the total user who have same rank
					if(isset($reward_details->rank_value)){
						$reward_details_rank = json_decode($reward_details->rank_value, true);
						// dd($reward_details_rank);
						$rankToFind = $val['rank'];
						$percentage = null;
						$defaultPercentage = 0;
						$percentage = $defaultPercentage;
						$found = false;
						foreach ($reward_details_rank as $data) {
							$from = (int) $data['rank_from'];
							$to = (int) $data['rank_to'];
							$percentage = (int) $data['percentage'];
							
							if($from != $to && $from < $to){
								$range = range($from, $to);
								foreach($range as $val){
									$percentage = (int) $data['percentage']/count($range);
								}
							}
							if ($rankToFind >= $from && $rankToFind <= $to) {
								// $percentage = (int) $data['percentage'];
								$percentage = $percentage;
								$found = true;
								break;
							}
							// dd($percentage);
						}
						if (!$found) {
							$percentage = $defaultPercentage;
						}
						/*if($reward_details_rank){
							
						}*/
						
						$per_user_reward_percent = $percentage/$get_rank_member; //reward percent for evry user
						
						// dd(json_decode($reward_details->rank_value, true));
						// dd($get_rank_member);
						$log[$k]['reward'] = $reward_total_amount*($per_user_reward_percent/100);
						
						//Update competitin Participate reward amount
						CompetitionParticipants::where('user_id', $val['participant_id'])->where('competition_id', $id)->update([
							'reward_amt' => $log[$k]['reward'],
						]);
						if($log[$k]['reward'] > 0){
							$user_wallet = $this->userService->findById($val['participant_id']);
							$wallet = $user_wallet->wallet;
							$wallet->reward_balance += $log[$k]['reward'];
							$wallet->save();
							
							Transaction::create([
								'user_id' => $val['participant_id'],
								'amount' => $log[$k]['reward'],
								'post_balance' => floatval($wallet->reward_balance) - floatval($log[$k]['reward']),
								'charge' => 0,
								'trx' => getTrx(),
								'type' => Type::PLUS->value,
								'wallet_type' => WalletType::REWARD->value,
								'source' => Source::REWARD->value,
								'details' => 'Virtual trade reward amount ' . getCurrencySymbol() . shortAmount($log[$k]['reward']),
							]);
							/*$this->transactionService->save(
								$this->transactionService->prepParams([
									'user_id' => $val['participant_id'],
									'amount' => $log[$k]['reward'],
									'type' => Type::PLUS,
									'wallet_type' => WalletType::REWARD->value,
									'details' => 'Virtual trade reward amount ' . getCurrencySymbol() . shortAmount($log[$k]['reward']),
									'wallet' => $this->walletService->findBalanceByWalletType(WalletType::REWARD->value, $wallet),
									'source' => Source::REWARD->value
								])
							);*/
						}
						Competition::where('id', $id)->update([
							'is_rewarded' => 1,
						]);
					}
				}
				// dd($rankCounters);
				$leaderboard = $log;
			}
		}
		// dd($leaderboard);
		
        return view('admin.competition.details', compact(
            'setTitle',
            'competition_details',
            'parameters',
            'tradeLogs',
            'leaderboard',
        ));
    }
}
