<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plugin_configurations', function (Blueprint $table) {
            $table->id();
            $table->string('code', 60)->nullable();
            $table->string('name', 120)->nullable();
            $table->text('short_key')->nullable();
            $table->tinyInteger('status')->default(\App\Enums\Status::ACTIVE->value);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plugin_configurations');
    }
};
