@extends('admin.layouts.main')
@section('panel')
	<style>
		.nav-link {
			padding: 0.5rem 1rem !important;
		}
	</style>
	<section>
		<h3 class="page-title">{{ __('Competition Details') }}</h3>
        <div class="row">
            <div class="col-lg-12 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white">{{ $competition_details->title }}</h4>
						<button class="i-btn btn--warning btn--md competitionRules">{{ __('Contest Rules') }}</button>
                    </div>

                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Prize Pool') }}
                                <span>{{ getCurrencySymbol() }} {{ number_format($competition_details->prize_pool_amt, 0) }}</span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Entry Fee') }}
                                <span>{{ getCurrencySymbol() }} {{ number_format($competition_details->entry_fee, 0) }}</span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Virtual Trade Amount') }}
                                <span>{{ getCurrencySymbol() }} {{ number_format($competition_details->trade_amount, 0) }}</span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Amount Per Virtual Trade') }}
                                <span>
                                    {{ getCurrencySymbol() }} {{ number_format($competition_details->per_trade_amount, 0) }}
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white">{{ __('Other Information') }}</h4>
                    </div>

                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Participants') }}
                                <span>{{ count($competition_details->participants) }}/{{ $competition_details->number_of_participants }}</span>
                            </li>
							
							@php
								$dateString = $competition_details->end_time;
								$endDate = \Carbon\Carbon::parse($dateString);
								$now = \Carbon\Carbon::now();
								$diff = $endDate->diff($now);
								$duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
							@endphp
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Ends In') }}
                                @if($now > $competition_details->end_time)
									<span>{{ __('Expired') }}</span>
								@else
									<span>{{ $duration }}</span>
								@endif
                            </li>

							@php
								$startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $competition_details->start_time);
								$startTime = $startTime->format('F, j (H:i)');
							@endphp
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                {{ __('Started At') }}
                                <span>{{ $startTime }}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 mb-4">
                <div class="card">
                    <div class="card-header">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
							<li class="nav-item" role="presentation">
								<button class="nav-link active" id="leaderboard-tab" data-bs-toggle="pill" data-bs-target="#leaderboard" type="button" role="tab" aria-controls="leaderboard" aria-selected="true">Leaderboard</button>
							</li>
							<li class="nav-item" role="presentation">
								<button class="nav-link" id="participants-tab" data-bs-toggle="pill" data-bs-target="#participants" type="button" role="tab" aria-controls="participants" aria-selected="false">Participants</button>
							</li>
							<li class="nav-item" role="presentation">
								<button class="nav-link" id="virtual-trade-tab" data-bs-toggle="pill" data-bs-target="#virtual-trade" type="button" role="tab" aria-controls="virtual-trade" aria-selected="false">Virtual Trade Logs</button>
							</li>
						</ul>
                    </div>

                    <div class="card-body">
                        <div class="tab-content" id="pills-tabContent">	
							<div class="tab-pane fade show active trading" id="leaderboard" role="tabpanel" aria-labelledby="leaderboard-tab">
								<div class="trade-table scroll-design dark--table">
									<div class="table-container">
										<table>
											<thead>
												<tr>
													<th>{{ __('Rank') }}</th>
													<th>{{ __('Participant') }}</th>
													<th>{{ __('Trades Completed') }}</th>
													<th>{{ __('Total Profit') }}</th>
													<th>{{ __('Total Loss') }}</th>
													<th>{{ __('Profit Loss Ratio') }}</th>
													<th>{{ __('Efficiency Ratio') }}</th>
													<th>{{ __('Reward') }}</th>
												</tr>
											</thead>
											<tbody>
											@forelse($leaderboard as $k=>$leaderboardVal)
												<tr>
													<td data-label="{{ __('Rank') }}">{{ $leaderboardVal['rank'] }}</td>
													<td data-label="{{ __('Participant') }}">{{ $leaderboardVal['participant'] }}</td>
													<td data-label="{{ __('Trades Completed') }}">{{ $leaderboardVal['trade_completed'] }}</td>
													<td data-label="{{ __('Total Profit') }}">{{ $leaderboardVal['total_profit'] }}</td>
													<td data-label="{{ __('Total Loss') }}">{{ $leaderboardVal['total_loss'] }}</td>
													<td data-label="{{ __('Profit Loss Ratio') }}">{{ $leaderboardVal['profit_loss_ratio'] }}</td>
													<td data-label="{{ __('Efficiency Ratio') }}">{{ $leaderboardVal['efficiency_ratio'] }}</td>
													<td data-label="{{ __('Reward') }}">{{$leaderboardVal['reward'] != '-' ? getCurrencySymbol() : ''}}{{ $leaderboardVal['reward'] }}</td>
												</tr>
											@empty
												<tr>
													<td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
												</tr>
											@endforelse
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<div class="tab-pane fade trading" id="participants" role="tabpanel" aria-labelledby="participants-tab">
								<div class="trade-table scroll-design dark--table">
									<div class="table-container">
										<table>
											<thead>
												<tr>
													<th>{{ __('S.No.') }}</th>
													<th>{{ __('Username') }}</th>
												</tr>
											</thead>
											<tbody>
											@php
												$i = 1;
											@endphp
											@forelse($competition_details->participants as $participant_val)
												<tr>
													<td data-label="{{ __('S.No.') }}">{{ $i }}</td>
													<td data-label="{{ __('Username') }}">{{ $participant_val->user_details->first_name ?? $participant_val->user_details->first_name }} {{ $participant_val->user_details->last_name ?? $participant_val->user_details->last_name }}</td>
												</tr>
												@php
													$i++;
												@endphp
											@empty
												<tr>
													<td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
												</tr>
											@endforelse
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<div class="tab-pane fade trading" id="virtual-trade" role="tabpanel" aria-labelledby="virtual-trade-tab">
								<div class="trade-table scroll-design dark--table">
									<div class="table-container">
										<table>
											<thead>
												<tr>
													<th>{{ __('Initiated At') }}</th>
													<th>{{ __('Entry Amount') }}</th>
													<th>{{ __('Volume') }}</th>
													<th>{{ __('Price Was') }}</th>
													<th>{{ __('Result Price') }}</th>
													<th>{{ __('Outcome') }}</th>
												</tr>
											</thead>
											<tbody>
											@forelse($tradeLogs as $tradeKey => $tradeLog)
												<tr>
													<td data-label="Initiated At">{{ diffForHumans($tradeLog->created_at) }}</td>
													<td data-label="Amount">{{ getCurrencySymbol() }}{{ shortAmount($tradeLog->amount) }}</td>
													<td data-label="Volume">
														<span class="badge {{ \App\Enums\Trade\TradeVolume::getColor($tradeLog->volume) }}">
															{{ \App\Enums\Trade\TradeVolume::getName($tradeLog->volume) }}
														</span> <!-- ($tradeLog->meta['result_price'], 6) -->
													</td>
													<td data-label="Price">{{ getCurrencySymbol() }}{{ number_format($tradeLog->original_price, 6) }}</td>
													<td data-label="{{ __('Result Price') }}">
															@if($tradeLog->meta != null)
																{{ getCurrencySymbol() }}{{ number_format($tradeLog->meta['result_price'], 6) }}
															@else
																{{ getCurrencySymbol() }}{{ number_format($tradeLog->result_price, 6) }}
															@endif
														</td>
													<td data-label="Outcome">
														<span class="badge {{ \App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome) }}">{{ \App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome) }}</span>
													</td>
												</tr>
											@empty
												<tr>
													<td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
												</tr>
											@endforelse
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
	
    
	<div class="modal" id="CompetitionRulesModal" tabindex="-1" aria-labelledby="CompetitionRulesModalLabel">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header primary--light border-0">
					<h5 class="modal-title" id="competitionTitle">Competition Rules</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>				
				<div class="modal-body">
				{!! $competition_details->rules !!}
				</div>
				<div class="modal-footer">
					<button type="button" class="i-btn btn--white btn--sm" data-bs-dismiss="modal" aria-label="Close">Close</button>
				</div>
			</div>
		</div>
	</div>
@endsection

@push('script-push')
<script>
$(document).on("click", ".competitionRules", function() {
	$('#CompetitionRulesModal').modal('show');
});
</script>
@endpush
