<?php $__env->startSection('panel'); ?>
    <section>
        <div class="row">
            <div class="col-xl-8 mx-auto">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(__('Withdraw Details')); ?></h4>
                    </div>
                    <div class="card-body">
                        <ul class="list-group detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Initiated At')); ?>

                                <span class="fw-bold fs-14"><?php echo e(showDateTime($withdraw->created_at)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Gateway')); ?>

                                <span class="fw-bold fs-14"> <?php echo e($withdraw->withdrawMethod->name ?? 'N/A'); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Rate')); ?>

                                <span class="fw-bold fs-14"><?php echo e(getCurrencySymbol()); ?>1 =  <?php echo e(shortAmount($withdraw->rate)); ?> <?php echo e($withdraw->withdrawMethod->currency ?? getCurrencyName()); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Trx')); ?>

                                <span class="fw-bold fs-14"><?php echo e($withdraw->trx); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Withdraw Amount')); ?>

                                <span class="fw-bold fs-14"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($withdraw->amount)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Charge')); ?>

                                <span class="fw-bold fs-14"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($withdraw->charge)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Final Amount')); ?>

                                <span class="fw-bold fs-14"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($withdraw->final_amount)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('After Charge')); ?>

                                <span class="fw-bold fs-14"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($withdraw->after_charge)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Status')); ?>

                                <span class="badge <?php echo e(\App\Enums\Payment\Withdraw\Status::getColor($withdraw->status)); ?>"><?php echo e(\App\Enums\Payment\Withdraw\Status::getName($withdraw->status)); ?></span>
                            </li>
                        </ul>

                        <div class="row gy-4 mt-3">
                             <?php if($withdraw->meta): ?>
                                <div class="col-12">
                                    <h6 class="mb-2"><?php echo e(__('Payment Information')); ?></h6>
                                   
                                    <ul class="list-group">
                                        <?php $__currentLoopData = $withdraw->meta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <?php echo e(__(replaceInputTitle($key))); ?>

                                                <span><?php echo e($meta); ?></span>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                             <?php endif; ?>

                            <?php if($withdraw->status == \App\Enums\Payment\Withdraw\Status::PENDING->value): ?>
                                <div class="col-12">
                                    <h6 class="mb-2"><?php echo e(__('Check the withdraw details and update its status.')); ?></h6>
                                    <button type="button" class="btn btn-md btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">Withdraw Actions</button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($withdraw->status == \App\Enums\Payment\Withdraw\Status::PENDING->value): ?>
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Update Withdraw Status</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.withdraw.update', $withdraw->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="status" class="form-label"><?php echo e(__('Status')); ?><sup class="text-danger">*</sup></label>
                                <select class="form-select" id="status" name="status" required>
                                    <option value="<?php echo e(\App\Enums\Payment\Withdraw\Status::SUCCESS->value); ?>"><?php echo e(__('Approved')); ?></option>
                                    <option value="<?php echo e(\App\Enums\Payment\Withdraw\Status::CANCEL->value); ?>"><?php echo e(__('Cancel')); ?></option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="details" class="form-label"><?php echo e(__('Reason Withdraw Update')); ?><sup class="text-danger">*</sup></label>
                                <textarea class="form-control" id="details" name="details" rows="4" placeholder="<?php echo e(__('Enter Details')); ?>" required><?php echo e(old('details')); ?></textarea>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn--primary btn--sm"><?php echo e(__('Submit')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/withdraw/details.blade.php ENDPATH**/ ?>