<?php $__env->startSection('panel'); ?>
    <section>
        <div class="row">
            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white"><?php echo e(__('Plan & Account Details')); ?></h4>
                    </div>

                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Plan Name')); ?>

                                <span><?php echo e(__($investment->plan_name)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Total Payable')); ?>

                                <span><?php echo e($investment->period); ?> <?php echo e(__('times')); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Name')); ?>

                                <span><?php echo e($investment->user->fullname); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Email')); ?>

                                <span>
                                    <a href="<?php echo e(route('admin.user.details', $investment->user->id)); ?>"><?php echo e($investment->user->email); ?></a>
                                </span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Joined At')); ?>

                                <span><?php echo e(showDateTime($investment->user->created_at)); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white"><?php echo e(__('Investment Information')); ?></h4>
                    </div>

                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Initiated At')); ?>

                                <span><?php echo e(showDateTime($investment->created_at)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Invest')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->amount)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Interest')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->interest_rate)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Interest Timeframe')); ?>

                                <span>Every <?php echo e($investment->time_table_name ?? 'Hour'); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Status')); ?>

                                <span class="badge <?php echo e(\App\Enums\Status::getColor($investment->status)); ?>"><?php echo e(\App\Enums\Status::getName($investment->status)); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white"><?php echo e(__('Other Information')); ?></h4>
                    </div>
                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Total Paid')); ?>

                                <span class="fw-bold"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->should_pay)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Should Pay')); ?>

                                <span class="fw-bold">
                                      <?php if($investment->should_pay != -1): ?>
                                            <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->interest)); ?>

                                      <?php else: ?>
                                         ****
                                      <?php endif; ?>
                                </span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Last Profit Time')); ?>

                                <span class="fw-bold"><?php echo e(showDateTime($investment->last_time)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Next Profit Time')); ?>

                                <span class="fw-bold"><?php echo e(showDateTime($investment->profit_time)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Capital Back')); ?>

                                <span class="badge <?php echo e(\App\Enums\Investment\Recapture::getColor($investment->recapture_type)); ?>"><?php echo e(\App\Enums\Investment\Recapture::getName($investment->recapture_type)); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <?php echo $__env->make('admin.partials.table', [
          'columns' => [
              'created_at' => __('admin.table.created_at'),
              'trx' => __('admin.table.trx'),
              'user_id' => __('admin.table.user'),
              'amount' => __('admin.table.amount'),
              'details' => __('admin.table.details'),
          ],
          'rows' => $commissions,
          'page_identifier' => \App\Enums\PageIdentifier::DAILY_COMMISSIONS->value,
      ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/binary/details.blade.php ENDPATH**/ ?>