<?php

namespace App\Enums\Transaction;

use App\Enums\EnumTrait;

enum Source: int
{
    use EnumTrait;

    case ALL = 1;
    case MATRIX = 2;
    case INVESTMENT = 3;
    case TRADE = 4;
    case VIRTUAL_TRADE = 5;
    case REWARD = 6;
    case REFERRAL = 7;
    case BONUS = 8;


    public static function getColor(int $status): string {
        return match($status) {
            self::ALL->value => 'badge--primary',
            self::MATRIX->value => 'badge--info',
            self::INVESTMENT->value => 'badge--success',
            self::TRADE->value => 'badge--danger',
            self::VIRTUAL_TRADE->value => 'badge--danger',
            self::REWARD->value => 'badge--primary',
            self::REFERRAL->value => 'badge--success',
            self::BONUS->value => 'badge--info',
            default => 'black'
        };
    }

    public static function getName(int $status): string {
        return match($status) {
            self::ALL->value => 'All',
            self::MATRIX->value => 'Matrix',
            self::INVESTMENT->value => 'Investment',
            self::TRADE->value => 'Trade',
            self::VIRTUAL_TRADE->value => 'Competition',
            self::REWARD->value => 'Reward',
            self::REFERRAL->value => 'Referral',
            self::BONUS->value => 'Bonus',
            default => 'Default'
        };
    }
}
