@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
        <h3 class="page-title">{{ __($setTitle) }}</h3>
        <div class="card">
            <div class="row">
                <div class="user-form">
                    <form method="POST" action="{{route('user.store.identity')}}">
                        @csrf
                        @if(!is_null($kycConfigurations))
                            <div class="row">
                                @foreach($kycConfigurations as $key => $kycConfiguration)
                                    <div class="col-lg-12">
                                        <div class="form-inner">
                                            <label for="{{ getArrayValue($kycConfiguration,'field_label') }}">{{ __(getArrayValue($kycConfiguration,'field_label')) }}</label>
                                            <input type="text" id="{{ getArrayValue($kycConfiguration,'field_label') }}" name="{{ getInputName(getArrayValue($kycConfiguration,'field_label')) }}" placeholder="{{ __("Enter ". getArrayValue($kycConfiguration,'field_label')) }}" required>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                        <div class="col-12">
                            <button type="submit" class="i-btn btn--primary btn--lg">{{ __('Save') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
