<table id="myTable" class="table">
    <thead>
        <tr>
            <th scope="col">{{ __('Initiated At') }}</th>
            <th scope="col">{{ __('Crypto') }}</th>
            <th scope="col">{{ __('Price Was') }}</th>
            <th scope="col">{{ __('Amount') }}</th>
            <th scope="col">{{ __('Arrival Time') }}</th>
            <th scope="col">{{ __('Result Price') }}</th>
            <th scope="col">{{ __('Volume') }}</th>
            <th scope="col">{{ __('Outcome') }}</th>
            <th scope="col">{{ __('Status') }}</th>
        </tr>
    </thead>
    <tbody>
        @forelse($tradeLogs as $key => $tradeLog)
            <tr>
                <td data-label="{{ __('Initiated At') }}">
                    {{ showDateTime($tradeLog->created_at) }}
                </td>
                <td data-label="{{ __('Crypto') }}">
                    {{ $tradeLog->cryptoCurrency->name }}
                </td>
                <td data-label="Price Was">
    {{ getCurrencySymbol() }}{{ number_format($tradeLog->original_price, 6) }}
</td>

                </td>
                <td data-label="{{ __('Amount') }}">
                    {{getCurrencySymbol()}}{{ shortAmount($tradeLog->amount) }}
                </td>
                <td data-label="{{ __('Arrival Time') }}">
                    {{ showDateTime($tradeLog->arrival_time) }}
                                 <td data-label="{{ __('Result Price') }}">
							@if($tradeLog->meta != null)
								{{ getCurrencySymbol() }}{{ number_format($tradeLog->meta['result_price'], 6) }}
							@else
								{{ getCurrencySymbol() }}{{ number_format($tradeLog->result_price, 6) }}
							@endif
                        </td>   <!--($tradeLog->result_price, 6) -->

                <td data-label="{{ __('Volume') }}">
                    <span class="i-badge {{ \App\Enums\Trade\TradeVolume::getColor($tradeLog->volume) }}">
                     {{ \App\Enums\Trade\TradeVolume::getName($tradeLog->volume) }}
                    </span>
                </td>
                <td data-label="{{ __('Outcome') }}">
                     <span class="i-badge {{ \App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome) }}">
                         {{ \App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome) }}
                    </span>
                </td>
                <td data-label="{{ __('Status') }}">
                     <span class="i-badge {{ \App\Enums\Trade\TradeStatus::getColor($tradeLog->status) }}">
                         {{ \App\Enums\Trade\TradeStatus::getName($tradeLog->status) }}
                    </span>
                </td>
            </tr>
        @empty
            <tr>
                <td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
            </tr>
        @endforelse
    </tbody>
</table>
