@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
        <div class="i-card-sm p-3 mb-4">
            <div class="row g-3">
                <div class="col-lg-4 col-md-6">
                    <div class="i-card-sm style-2 primary--light shadow-none rounded-2">
                        <span>{{ __('Primary Balance') }}</span><span class="text--dark fw-bold">{{ getCurrencySymbol() }}{{shortAmount(Auth::user()->wallet->primary_balance)}}</span>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="i-card-sm style-2 primary--light shadow-none rounded-2">
                        <span>{{ __('Investment Balance') }}</span> <span class="text--dark fw-bold"> {{ getCurrencySymbol() }}{{shortAmount(Auth::user()->wallet->investment_balance)}}</span>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="i-card-sm style-2 primary--light shadow-none rounded-2">
                        <span>{{ __('Trade Balance') }}</span> <span class="text--dark fw-bold">{{ getCurrencySymbol() }}{{shortAmount(Auth::user()->wallet->trade_balance)}}</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="fs-17 border--left mb-4">{{ __("Transfer the balance from your trade and investment account to your primary account, and subsequently initiate a withdrawal of your balance.")}}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row align-items-center gy-4">
                            <div class="user-form">
                                <form method="POST" action="{{ route('user.wallet.transfer.own-account') }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-inner">
                                                <label for="account">{{ __('Account') }}</label>
                                                <select id="account" name="account" required>
                                                    <option value="">{{ __('Select One') }}</option>
                                                    @foreach (\App\Enums\Transaction\WalletType::cases() as $status)
                                                        @unless(in_array($status->value, [\App\Enums\Transaction\WalletType::PRACTICE->value,\App\Enums\Transaction\WalletType::PRIMARY->value,]) )
                                                            <option value="{{ $status->value }}">{{ $status->name  }}</option>
                                                        @endunless
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="form-inner">
                                                <label for="amount">{{ __('Amount') }}</label>
                                                <input type="number" id="amount" name="amount" placeholder="{{ __('Enter Amount') }}" required>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <button type="submit" class="i-btn btn--primary btn--lg">{{ __('Save') }}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

           <!-- <div class="col-lg-6">
                <div class="i-card-sm">
                    <div class="card-header">
                        <h4 class="fs-17 border--left mb-4">{{ __("Transfer the balance from your primary account to other users.") }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row align-items-center gy-4">
                            @if(getArrayValue($setting->system_configuration, 'balance_transfer.value') == \App\Enums\Status::ACTIVE->value)
                                <div class="user-form">
                                    <form method="POST" action="{{ route('user.wallet.transfer.other-account') }}">
                                        @csrf
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-inner">
                                                    <label for="user">{{ __('Users') }}</label>
                                                    <select  class="select2-js" id="user" name="user_id" required>
                                                        <option value="">{{ __('Select One') }}</option>
                                                        @foreach($users as $key => $user)
                                                            <option value="{{ $user->id }}">{{ __($user->email) }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="form-inner">
                                                    <label for="amount">{{ __('Amount') }}</label>
                                                    <input type="number" id="amount" name="amount" placeholder="{{ __('Enter Amount') }}" required>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit" class="i-btn btn--primary btn--lg">{{ __('Save') }}</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            @else
                                <p>{{ __('Balance Transfer Currently Unavailable') }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div> -->
        </div>
    </div>
@endsection
