<?php

namespace App\Http\Requests;

use App\Enums\Status;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class CompetitionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(Request $request): array
    {
        return [
            'title' => ['required'],
            'competition_start' => ['required'],
            'competition_end' => ['required'],
            'prize_pool_amt' => ['required', 'numeric', 'gt:0'],
            'entry_fee' => ['required', 'numeric', 'gt:0'],
            'trade_amount' => ['required', 'numeric', 'gt:0'],
            'per_trade_amount' => ['required', 'numeric', 'gt:0'],
            'number_of_participants' => ['required', 'numeric', 'gt:0'],
            'status' => ['required', 'numeric', Rule::in(Status::values())],
            'trade_expiry_time' => ['required'],
        ];
    }
}
