@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
        <h3 class="page-title">{{ __($setTitle) }}</h3>
        <div class="i-card-sm">
            <div class="row">
                <div class="user-form">
                    <div class="col-lg-12 mb-4">
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ __('Rate') }}
                                <span>{{ getCurrencySymbol() }}1 =  {{shortAmount($payment->rate)}} {{ $gateway->currency ?? getCurrencyName() }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ __('Deposit Amount') }}
                                <span>{{ getCurrencySymbol() }}{{shortAmount($payment->amount)}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ __('Charge') }}
                                <span>{{ getCurrencySymbol() }}{{shortAmount($payment->charge)}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ __('Final Amount') }}
                                <span>{{ getCurrencySymbol() }}{{shortAmount($payment->final_amount)}}</span>
                            </li>
                        </ul>
                    </div>

                    <form method="POST" action="{{ route('user.payment.traditional') }}" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="payment_intent" value="{{ $payment->trx }}">
                        <input type="hidden" name="gateway_code" value="{{ $gateway->code }}">
                        <div class="row">
                            @foreach($gateway->parameter as $key => $parameter)
                                @php
                                    $parameter = is_array($parameter) ? $parameter : [];
                                @endphp
                                <div class="col-lg-12">
                                    <div class="form-inner">
                                        <label for="{{ getArrayValue($parameter,'field_label') }}">{{ __(getArrayValue($parameter,'field_label')) }}</label>
                                        @if(getArrayValue($parameter,'field_type') == 'file')
                                            <input type="file" id="{{ getArrayValue($parameter,'field_label') }}" name="{{ getArrayValue($parameter,'field_name') }}" required>
                                        @elseif(getArrayValue($parameter,'field_type') == 'text')
                                            <input type="text" id="{{ getArrayValue($parameter,'field_label') }}" name="{{ getArrayValue($parameter,'field_name') }}" placeholder="{{ __("Enter ". getArrayValue($parameter,'field_label')) }}" required>
                                        @elseif(getArrayValue($parameter,'field_type') == 'textarea')
                                            <textarea id="{{ getArrayValue($parameter,'field_label') }}" name="{{ getArrayValue($parameter,'field_name') }}" placeholder="{{ __("Enter ". getArrayValue($parameter,'field_label')) }}" required></textarea>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-12">
                            <button type="submit" class="i-btn btn--primary btn--lg">{{ __('Save') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

