<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Supersim\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class IpCommandOptions {
    /**
     * @param string $payloadType Indicates how the payload is encoded
     * @param string $callbackUrl The URL we should call after we have sent the IP
     *                            Command
     * @param string $callbackMethod The HTTP method we should use to call
     *                               callback_url
     * @return CreateIpCommandOptions Options builder
     */
    public static function create(string $payloadType = Values::NONE, string $callbackUrl = Values::NONE, string $callbackMethod = Values::NONE): CreateIpCommandOptions {
        return new CreateIpCommandOptions($payloadType, $callbackUrl, $callbackMethod);
    }

    /**
     * @param string $sim The SID or unique name of the Sim resource that IP
     *                    Command was sent to or from.
     * @param string $simIccid The ICCID of the Sim resource that IP Command was
     *                         sent to or from.
     * @param string $status The status of the IP Command
     * @param string $direction The direction of the IP Command
     * @return ReadIpCommandOptions Options builder
     */
    public static function read(string $sim = Values::NONE, string $simIccid = Values::NONE, string $status = Values::NONE, string $direction = Values::NONE): ReadIpCommandOptions {
        return new ReadIpCommandOptions($sim, $simIccid, $status, $direction);
    }
}

class CreateIpCommandOptions extends Options {
    /**
     * @param string $payloadType Indicates how the payload is encoded
     * @param string $callbackUrl The URL we should call after we have sent the IP
     *                            Command
     * @param string $callbackMethod The HTTP method we should use to call
     *                               callback_url
     */
    public function __construct(string $payloadType = Values::NONE, string $callbackUrl = Values::NONE, string $callbackMethod = Values::NONE) {
        $this->options['payloadType'] = $payloadType;
        $this->options['callbackUrl'] = $callbackUrl;
        $this->options['callbackMethod'] = $callbackMethod;
    }

    /**
     * Indicates how the payload is encoded. Either `text` or `binary`. Defaults to `text`.
     *
     * @param string $payloadType Indicates how the payload is encoded
     * @return $this Fluent Builder
     */
    public function setPayloadType(string $payloadType): self {
        $this->options['payloadType'] = $payloadType;
        return $this;
    }

    /**
     * The URL we should call using the `callback_method` after we have sent the IP Command.
     *
     * @param string $callbackUrl The URL we should call after we have sent the IP
     *                            Command
     * @return $this Fluent Builder
     */
    public function setCallbackUrl(string $callbackUrl): self {
        $this->options['callbackUrl'] = $callbackUrl;
        return $this;
    }

    /**
     * The HTTP method we should use to call `callback_url`. Can be `GET` or `POST`, and the default is `POST`.
     *
     * @param string $callbackMethod The HTTP method we should use to call
     *                               callback_url
     * @return $this Fluent Builder
     */
    public function setCallbackMethod(string $callbackMethod): self {
        $this->options['callbackMethod'] = $callbackMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Supersim.V1.CreateIpCommandOptions ' . $options . ']';
    }
}

class ReadIpCommandOptions extends Options {
    /**
     * @param string $sim The SID or unique name of the Sim resource that IP
     *                    Command was sent to or from.
     * @param string $simIccid The ICCID of the Sim resource that IP Command was
     *                         sent to or from.
     * @param string $status The status of the IP Command
     * @param string $direction The direction of the IP Command
     */
    public function __construct(string $sim = Values::NONE, string $simIccid = Values::NONE, string $status = Values::NONE, string $direction = Values::NONE) {
        $this->options['sim'] = $sim;
        $this->options['simIccid'] = $simIccid;
        $this->options['status'] = $status;
        $this->options['direction'] = $direction;
    }

    /**
     * The SID or unique name of the Sim resource that IP Command was sent to or from.
     *
     * @param string $sim The SID or unique name of the Sim resource that IP
     *                    Command was sent to or from.
     * @return $this Fluent Builder
     */
    public function setSim(string $sim): self {
        $this->options['sim'] = $sim;
        return $this;
    }

    /**
     * The ICCID of the Sim resource that IP Command was sent to or from.
     *
     * @param string $simIccid The ICCID of the Sim resource that IP Command was
     *                         sent to or from.
     * @return $this Fluent Builder
     */
    public function setSimIccid(string $simIccid): self {
        $this->options['simIccid'] = $simIccid;
        return $this;
    }

    /**
     * The status of the IP Command. Can be: `queued`, `sent`, `received` or `failed`. See the [IP Command Status Values](https://www.twilio.com/docs/wireless/api/ipcommand-resource#status-values) for a description of each.
     *
     * @param string $status The status of the IP Command
     * @return $this Fluent Builder
     */
    public function setStatus(string $status): self {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * The direction of the IP Command. Can be `to_sim` or `from_sim`. The value of `to_sim` is synonymous with the term `mobile terminated`, and `from_sim` is synonymous with the term `mobile originated`.
     *
     * @param string $direction The direction of the IP Command
     * @return $this Fluent Builder
     */
    public function setDirection(string $direction): self {
        $this->options['direction'] = $direction;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Supersim.V1.ReadIpCommandOptions ' . $options . ']';
    }
}