<div class="trade-table scroll-design dark--table">
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>{{ __('Initiated At') }}</th>
                    <th>{{ __('Entry Amount') }}</th>
                    <th>{{ __('Volume') }}</th>
                    <th>{{ __('Price Was') }}</th>
                    <th>{{ __('Result Price') }}</th>
                    <th>{{ __('Outcome') }}</th>
                </tr>
            </thead>
            <tbody>
            @forelse($tradeLogs as $tradeKey => $tradeLog)
                <tr>
                    <td data-label="Initiated At">{{ diffForHumans($tradeLog->created_at) }}</td>
                    <td data-label="Amount">{{ getCurrencySymbol() }}{{ shortAmount($tradeLog->amount) }}</td>
                    <td data-label="Volume">
                        <span class="i-badge {{ \App\Enums\Trade\TradeVolume::getColor($tradeLog->volume) }}">
                            {{ \App\Enums\Trade\TradeVolume::getName($tradeLog->volume) }}
                        </span> <!-- ($tradeLog->meta['result_price'], 6) -->
                    </td>
                    <td data-label="Price">{{ getCurrencySymbol() }}{{ number_format($tradeLog->original_price, 6) }}</td>
                    <td data-label="{{ __('Result Price') }}">
							@if($tradeLog->meta != null)
								{{ getCurrencySymbol() }}{{ number_format($tradeLog->meta['result_price'], 6) }}
							@else
								{{ getCurrencySymbol() }}{{ number_format($tradeLog->result_price, 6) }}
							@endif
                        </td>
                    <td data-label="Outcome">
                        <span class="i-badge {{ \App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome) }}">{{ \App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome) }}</span>
                    </td>
                </tr>
            @empty
                <tr>
                    <td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </div>
</div>
