<?php

namespace App\Http\Controllers;

use App\Enums\CronCode;
use App\Models\Cron;
use App\Models\CryptoCurrency;
use App\Services\Api\CoinGeckoService;
use App\Services\Investment\InvestmentService;
use App\Services\Investment\Staking\StakingInvestmentService;
use App\Services\Trade\ActivityLogService;
use App\Services\Trade\CryptoCurrencyService;
use Carbon\Carbon;
use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Support\Facades\Artisan;

class CronController extends Controller
{
    public function __construct(
        protected ActivityLogService $activityLogService,
        protected InvestmentService $investmentService,
        protected CryptoCurrencyService $cryptoCurrencyService,
        protected CoinGeckoService $coinGeckoService,
        protected StakingInvestmentService $stakingInvestmentService
    )
    {

    }

    /**
     * @throws GuzzleException
     */
    public function handle(): void
    {
        $cron = Cron::all();
        foreach ($cron as $value) {
            if ($value->code == CronCode::CRYPTO_CURRENCY->value &&
                ($value->last_run === null || Carbon::parse($value->last_run)->addDay()->isPast())) {
                $this->cryptoHandle();
                $value->last_run = Carbon::now();
            }

            if ($value->code == CronCode::INVESTMENT_PROCESS->value || $value->code == CronCode::TRADE_OUTCOME->value){
                $value->last_run = Carbon::now();
            }

            $value->save();
        }

        $this->investmentService->cron();
        $this->stakingInvestmentService->cron();
        $this->activityLogService->cron();
    }


    /**
     * @throws GuzzleException
     */
    public function cryptoHandle(): void
    {
        if (CryptoCurrency::count() === 0) {
            $this->cryptoSave();
        }

        $this->coinGeckoService->getTopGainerLoser();
    }

    /**
     * @throws GuzzleException
     */
    protected function cryptoSave(): void
    {
        foreach ($this->coinGeckoService->getTopCryptoCurrencies(100) as $value){
            $this->cryptoCurrencyService->save($this->cryptoCurrencyService->prepParams($value));
        }
    }

}
