<?php

namespace App\Http\Controllers\User;

use App\Concerns\CustomValidation;
use App\Enums\User\KycStatus;
use App\Http\Controllers\Controller;
use App\Services\Investment\CommissionService;
use App\Services\Investment\InvestmentService;
use App\Services\Investment\MatrixInvestmentService;
use App\Services\Payment\DepositService;
use App\Services\Payment\TransactionService;
use App\Services\Payment\WithdrawService;
use App\Services\SettingService;
use App\Services\Trade\ActivityLogService;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\View\View;
use App\Models\CompetitionParticipants;
use App\Models\Competition;
use App\Models\Wallet;
use App\Models\MatrixInvestmentDetails;
use Carbon\Carbon;
use App\Services\UserService; // Import the service

   


class HomeController extends Controller
{

    use CustomValidation;

    public function __construct(
        protected TransactionService $transactionService,
        protected CommissionService $commissionService,
        protected DepositService $depositService,
        protected InvestmentService $investmentService,
        protected WithdrawService $withdrawService,
        protected ActivityLogService $activityLogService,
        protected MatrixInvestmentService $matrixInvestmentService,
                protected UserService $userService,
    )
    {

    }
    
public function index(): View
{
    $setTitle = "Dashboard";
    $userId = (int) Auth::id();
    $user = Auth::user();  // Add this line to fetch the authenticated user
    $investmentReport = $this->investmentService->getInvestmentReport($userId);
    [$months, $depositMonthAmount, $withdrawMonthAmount] = $this->depositService->monthlyReport($userId);
    $deposit = $this->depositService->getReport($userId);
    $withdraw = $this->withdrawService->getReport($userId);
    $tradeReport = $this->activityLogService->getTradeReport($userId);
    $transactions = $this->transactionService->latestTransactions(userId: $userId);
    $commissions = $this->commissionService->getCommissionsSum($userId);
    $matrixInvest = $this->matrixInvestmentService->findByUserId($userId);

    // Fetch all competitions
    $competitions = Competition::with(['participants'])->get();

    // Calculate total prize pool
    $totalPrizePool = $competitions->sum('prize_pool_amt');

    // Count total competitions
    $totalCompetitions = $competitions->count();

    // Fetch live competitions
    $now = Carbon::now();
    $liveCompetitions = $competitions->where('start_time', '<=', $now)
        ->where('end_time', '>=', $now)
        ->count();

    // Count running competitions
    $runningCompetitions = $liveCompetitions;

    // Count completed competitions
    $completedCompetitions = $competitions->where('end_time', '<', $now)
        ->filter(function ($competition) {
            return $competition->participants->contains('user_id', Auth::id());
        })
        ->count();

    // Fetch commission details with pagination
    $commission_details = MatrixInvestmentDetails::where('franchaisee_id', $userId)
        ->with(['matrix_invest'])
        ->paginate(getPaginate());

    // Calculate total franchisee commission
    $totalFranchiseeCommission = MatrixInvestmentDetails::where('franchaisee_id', $userId)
        ->sum('franchaisee_commission_amount');

    return view('user.dashboard', compact(
        'setTitle',
        'transactions',
        'commissions',
        'months',
        'depositMonthAmount',
        'withdrawMonthAmount',
        'investmentReport',
        'tradeReport',
        'deposit',
        'withdraw',
        'matrixInvest',
        'totalCompetitions',
        'liveCompetitions',
        'runningCompetitions',
        'commission_details',
        'completedCompetitions',
        'totalFranchiseeCommission',
        'user'  // Add the user to the compact method
    ));
}


    
   /** public function index(): View
    {
        $setTitle = "Dashboard";

        $userId = (int)Auth::id();
        $investmentReport = $this->investmentService->getInvestmentReport($userId);
        [$months, $depositMonthAmount, $withdrawMonthAmount] = $this->depositService->monthlyReport($userId);
        $deposit = $this->depositService->getReport($userId);
        $withdraw = $this->withdrawService->getReport($userId);
        $tradeReport = $this->activityLogService->getTradeReport($userId);
        $transactions = $this->transactionService->latestTransactions(userId: $userId);
        $commissions = $this->commissionService->getCommissionsSum($userId);
        $matrixInvest = $this->matrixInvestmentService->findByUserId($userId);
		
		//Reset Virtual_trade_wallet
		$participated_competition = CompetitionParticipants::where('user_id', $userId)->where('competition_trade_amt', '>', '0')->get();
		foreach($participated_competition as $participated_competition_val){
			$chk_competition_expired = Competition::where('id', $participated_competition_val->competition_id)->first();
			if(Carbon::now() > $chk_competition_expired->end_time){
				$existing_balance = Wallet::where('user_id', $userId)->first();
				Wallet::where('user_id', $userId)->update([
					'virtual_trade_balance'=>floatval($existing_balance->virtual_trade_balance) - floatval($participated_competition_val->competition_trade_amt)
				]);
				CompetitionParticipants::where('id', $participated_competition_val->id)->update([
					'competition_trade_amt'=>'0.00000000'
				]);
			}
		}
		
        return view('user.dashboard', compact(
            'setTitle',
            'transactions',
            'commissions',
            'months',
            'depositMonthAmount',
            'withdrawMonthAmount',
            'investmentReport',
            'tradeReport',
            'deposit',
            'withdraw',
            'matrixInvest',
        ));
    }
        */
        
        
    public function setting(): View
    {
        $setTitle = "Setting";
        $user = Auth::user();

        return view('user.setting', compact('setTitle', 'user'));
    }

    /**
     * @return View
     */
    public function transactions(): View
    {
        $setTitle = 'Transactions';

        $userId = (int)Auth::id();
        $transactions = $this->transactionService->getTransactions(userId: $userId);

        return view('user.transaction', compact(
            'setTitle',
            'transactions',
        ));
    }



   public function verifyIdentity(): View
    {
        $setTitle = "Verify Identify";
        $kycConfigurations = SettingService::getKycConfiguration();

        return view('user.kyc', compact(
            'setTitle',
            'kycConfigurations'
        ));
    }

    /**
     * @throws ValidationException
     */
    public function storeIdentity(Request $request): RedirectResponse
    {
        $setting = SettingService::getSetting();
        $this->validate($request, $this->parameterValidation($setting->kyc_configuration, true));

        $parameters = Arr::pluck($setting->kyc_configuration, 'field_label');
        foreach ($parameters as &$parameter) {
            $parameter = getInputName($parameter);
        }
        unset($parameter);

        $user = Auth::user();
        $meta = $user->meta ?? [];
        $user->meta = Arr::set($meta, 'identity', $request->only($parameters));
        $user->kyc_status = KycStatus::REQUESTED->value;
        $user->save();

        return to_route('user.dashboard')->with('notify', [['success', "Identity has been submitted successfully"]]);
    }


    public function findUser(Request $request): \Illuminate\Http\JsonResponse
    {
        $user = $this->userService->findByUuid($request->input('uuid'));

        if ($user && $user->uuid == auth()->user()->uuid) {
            return response()->json([
                'status' => true,
                'message' => 'You cannot send money to your own account'
            ]);
        }

        if ($user) {
            return response()->json([
                'status' => false,
                'message' => 'User found successfully'
            ]);
        } else {
            return response()->json([
                'status' => true,
                'message' => 'User not found'
            ]);
        }
    }


}
