@extends('admin.layouts.main')
@section('panel')
    <section>
        <div class="container-fluid p-0">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__($setTitle)}}</h4>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.competition.store')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-wrapper">
                            <div class="row g-3">
                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="title" class="form-label"> @lang('Title') <sup class="text-danger">*</sup></label>
                                    <input type="text" class="form-control" name="title" id="title" value="{{old('title')}}" placeholder="@lang('Enter Title')" required>
                                </div>

                                <div class="mb-3 col-lg-3 col-md-12">
                                    <label for="competition_start" class="form-label"> @lang('Competition Started At') <sup class="text-danger">*</sup></label>
                                    <input type="text" class="form-control datepicker-here" name="competition_start" id="competition_start" value="{{old('competition_start')}}" placeholder="@lang('Competition Started At')"
                                   data-language="en" data-position="bottom right" data-timepicker="1" autocomplete="off" required>
                                </div>

                                <div class="mb-3 col-lg-3 col-md-12">
                                    <label for="competition_end" class="form-label"> @lang('Competition Ends At') <sup class="text-danger">*</sup></label>
                                    <input type="text" class="form-control datepicker-here" name="competition_end" id="competition_end" value="{{old('competition_end')}}" placeholder="@lang('Competition Ends At')"
                                   data-language="en" data-position="bottom right" data-timepicker="1" autocomplete="off" required>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="prize_pool_amt" class="form-label"> @lang('Prize Pool') <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="prize_pool_amt" name="prize_pool_amt" step="any" placeholder="Enter Prize Pool Amount" value="{{old('prize_pool_amt')}}" required="">
									</div>
                                </div>
								
                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="entry_fee" class="form-label"> @lang('Entry Fee') <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="entry_fee" name="entry_fee" step="any" placeholder="Enter Entry Fee" value="{{old('entry_fee')}}" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="trade_amount" class="form-label"> @lang('Trade Amount') <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="trade_amount" name="trade_amount" step="any" placeholder="Enter Trade Amount" value="{{old('trade_amount')}}" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="per_trade_amount" class="form-label"> @lang('Per Trade Amount') <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="per_trade_amount" name="per_trade_amount" step="any" placeholder="Enter Per Trade Amount" value="{{old('per_trade_amount')}}" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="number_of_participants" class="form-label"> @lang('Participants') <sup class="text-danger">*</sup></label>
                                    <input type="number" class="form-control" name="number_of_participants" id="number_of_participants" value="{{old('number_of_participants')}}" placeholder="@lang('Enter Participants Number')" required>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="status" class="form-label">@lang('Status') <sup class="text-danger">*</sup></label>
                                    <select class="form-select" id="status" name="status">
                                        @foreach(\App\Enums\Status::toArray() as $key =>  $status)
                                            <option value="{{ $status }}">{{ replaceInputTitle($key) }}</option>
                                        @endforeach
                                    </select>
                                </div>
								
                                <div class="form-group mb-3 col-lg-4 col-md-12">
									<label for="parameter" class="form-label">{{ __('Trade Expiry Time') }}</label>
									<select class="form-select" id="parameter" name="trade_expiry_time" required>
										<option value="">{{ __('Select Expiration Time') }}</option>
										@foreach($parameters as $key => $parameter)
											<option value="{{ $parameter->id }}">
												{{ __('Time') }}: {{$parameter->time.' ' .\App\Enums\Trade\TradeParameterUnit::getName($parameter->unit) }}
											</option>
										@endforeach
									</select>
                                </div>
								
                                <div class="form-group mb-3 col-lg-4 col-md-12">
									<label for="ranking_id" class="form-label">{{ __('Ranking Id') }}</label>
									<select class="form-select" id="ranking_id" name="ranking_id" required>
										<option value="">{{ __('Select Ranking') }}</option>
										@foreach($rankings as $key => $ranking)
											<option value="{{ $ranking->participant_count }}">{{ $ranking->participant_count }}
											</option>
										@endforeach
									</select>
                                </div>
								
                                <div class="mb-3 col-lg-4 col-md-12">
                                    <label for="rules" class="form-label"> @lang('Rules')</label>
									<textarea class="form-control" name="rules" id="rules" value="" placeholder="@lang('Enter Rules')">{{old('rules')}}</textarea>
                                </div>
                            </div>
                        </div>

                        <button class="i-btn btn--primary btn--lg">@lang('Submit')</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection

