@php
    $fixedCryptoCoinContent = \App\Services\FrontendService::getFrontendContent(\App\Enums\Frontend\SectionKey::CRYPTO_COIN, \App\Enums\Frontend\Content::FIXED);
@endphp

@extends('layouts.auth')
@section('content')
    <main>
        <div class="form-section white img-adjust">
            <div class="linear-center"></div>
            <div class="container-fluid px-0">
                <div class="row justify-content-center align-items-center gy-5">
                    <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-8 col-sm-10 position-relative">
                        <div class="eth-icon">
                            <img src="{{ displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'first_crypto_coin'), "450X450") }}" alt="image">
                        </div>
                        <div class="bnb-icon">
                            <img src="{{ displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'second_crypto_coin'), "450X450") }}" alt="image">
                        </div>
                        <div class="ada-icon">
                            <img src="{{ displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'third_crypto_coin'), "450X450") }}" alt="image">
                        </div>
                        <div class="sol-icon">
                            <img src="{{ displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'fourth_crypto_coin'), "450X450") }}" alt="image">
                        </div>

                        <div class="form-wrapper">
                            <p>{{ __("Thanks for signing up! Please verify your phone by provide the code below. If you didn't receive it, we'll gladly send another") }}</p>
							@if (session('status'))
								<div class="mb-4 mt-2 text-success">
									{{ session('status') }}
								</div>
							@endif

                            {{--<form method="POST" action="{{ route('verification.send') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <button class="i-btn btn--lg btn--primary w-100" type="submit">{{ __('Resend Verification Email') }}</button>
                                    </div>
                                </div>
                            </form>--}}
                            <div class="have-account">
                                <form method="post" action="{{ route('phoneverification.verify') }}">
                                    @csrf
									<div class="row">
										<div class="col-12">
											<div class="form-inner">
												<label for="code">Verification Code</label>
												<input id="code" name="code" type="text" placeholder="Verification Code" required autofocus>
												@if ($errors->has('code'))
													<span class="invalid-feedback" role="alert">
														<strong>{{ $errors->first('code') }}</strong>
													</span>
												@endif
											</div>
										</div>
										<div class="col-12">
											<button type="submit" value="Register" class="i-btn btn--lg btn--primary w-100">Verify Phone</button>
										</div>
                                    </div>
                                </form>
                            </div>
                            <div class="have-account">
								<div class="row">
									<div class="col-6 text-start">
										<form method="POST" action="{{ route('phoneverification.send') }}">
											@csrf
											<button class="btn btn-outline-secondary" type="submit">{{ __('Resend Code') }}</button>
										</form>
									</div>
									<div class="col-6 text-end">
										<form method="POST" action="{{ route('logout') }}">
											@csrf
											<button type="submit" class="btn btn-outline-secondary">
												{{ __('Log Out') }}
											</button>
										</form>
									</div>
								</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
