<div class="market-widget mb-4 dark--card">
    <div class="card--title">
        <h5>{{ __('Rise/Fall') }}</h5>
    </div>
    <form method="POST" action="{{ route('user.trade.store', $crypto->id) }}">
        @csrf

        <!-- Hidden input for trade type -->
        <input type="hidden" value="{{ request()->routeIs('user.trade.practice') ? \App\Enums\Trade\TradeType::PRACTICE->value : \App\Enums\Trade\TradeType::TRADE->value }}" name="type">

      <!-- Amount input field -->
        <div class="input-single">
            <label for="amount">{{ __('Amount') }}</label>
            @php
                $applyBinaryTradeCommissions = $setting->binary_trade_set;
                
                // Generate a random percentage between 30 and 50
                $randomPercentage = rand(30, 50) / 100;
                // Calculate the amount using the random percentage
                $calculatedAmount = $tradeBalance * $randomPercentage;
            @endphp
        
            @if ($applyBinaryTradeCommissions)
                <!-- Read-only input field if binary trade commissions are applied -->
                <input type="hidden" id="amount" name="amount" value="{{ old('amount', $calculatedAmount) }}" placeholder="0.00" required readonly>
            @else
                <!-- Editable input field if binary trade commissions are not applied -->
                <input type="text" id="amount" name="amount" value="{{ old('amount') }}" placeholder="0.00" required>
            @endif
        </div>


        <!-- Expiry Time -->
        <div class="input-single">
            <label for="parameter">{{ __('Expiry Time') }}</label>
            <div class="toggle-buttons">
                @foreach($parameters as $parameter)
                    <label class="btn-toggle">
                        <input type="radio" name="parameter_id" value="{{ $parameter->id }}" required>
                        <span>{{ $parameter->time . ' ' . \App\Enums\Trade\TradeParameterUnit::getName($parameter->unit) }}</span>
                    </label>
                @endforeach
            </div>
        </div>

        <!-- Profit Card -->
        <div class="profit-card">
            <p>{{ __('Profit') }}</p>
            <div class="percent">
                <span id="profit_amount">+0.00</span>
                <sub> / {{ getArrayValue($setting->commissions_charge, 'binary_trade_commissions', 0) }} %</sub>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="d-flex justify-content-center align-items-center gap-3">
            <button type="submit" name="volume" value="{{ \App\Enums\Trade\TradeVolume::HIGH->value }}" class="i-btn btn--md btn--success capsuled w-100">
                {{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::HIGH->value)) }} <i class="bi bi-arrow-up"></i>
            </button>
            <button type="submit" name="volume" value="{{ \App\Enums\Trade\TradeVolume::LOW->value }}" class="i-btn btn--md btn--danger capsuled w-100">
                {{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::LOW->value)) }} <i class="bi bi-arrow-down"></i>
            </button>
        </div>
    </form>
</div>



{{--
<div class="market-widget mb-4 dark--card">
    <div class="card--title">
        <h5>{{ __('Rise/Fall') }}</h5>
    </div>
    <form method="POST" action="{{ route('user.trade.store', $crypto->id) }}">
        @csrf
        <input type="hidden" value="{{ request()->routeIs('user.trade.practice') ? \App\Enums\Trade\TradeType::PRACTICE->value : \App\Enums\Trade\TradeType::TRADE->value }}" name="type">
        <div class="input-single">
            <label for="amount">{{ __('Amount') }}</label>
            <input type="text" id="amount" name="amount" value="{{ old('amount') }}" placeholder="0.00" required>
        </div>

        <div class="input-single">
            <label for="parameter">{{ __('Expiry Time') }}</label>
            <div class="toggle-buttons">
                @foreach($parameters as $key => $parameter)
                    <label class="btn-toggle">
                        <input type="radio" name="parameter_id" value="{{ $parameter->id }}" required>
                        <span>{{ $parameter->time . ' ' . \App\Enums\Trade\TradeParameterUnit::getName($parameter->unit) }}</span>
                    </label>
                @endforeach
            </div>
        </div>
        <div class="profit-card">
            <p>{{ __('Profit') }}</p>
            <div class="percent">
                <span id="profit_amount">+0.00</span>
                <sub> / {{ getArrayValue($setting->commissions_charge, 'binary_trade_commissions', 0) }} %</sub>
            </div>
        </div>
        <div class="d-flex justify-content-center align-items-center gap-3">
            <button type="submit" name="volume" value="{{ \App\Enums\Trade\TradeVolume::HIGH->value }}" class="i-btn btn--md btn--success capsuled w-100">{{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::HIGH->value)) }} <i class="bi bi-arrow-up"></i></button>
            <button type="submit" name="volume" value="{{ \App\Enums\Trade\TradeVolume::LOW->value }}" class="i-btn btn--md btn--danger capsuled w-100">{{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::LOW->value)) }} <i class="bi bi-arrow-down"></i></button>
        </div>
    </form>
</div>



<div class="market-widget mb-4 dark--card">
    <div class="card--title">
        <h5>{{ __('Rise/Fall') }}</h5>
    </div>
    <form method="POST" action="{{ route('user.trade.store', $crypto->id) }}">
        @csrf

        <!-- Hidden input for trade type -->
        <input type="hidden" value="{{ request()->routeIs('user.trade.practice') ? \App\Enums\Trade\TradeType::PRACTICE->value : \App\Enums\Trade\TradeType::TRADE->value }}" name="type">

        <!-- Amount input field -->
        <div class="input-single">
            <label for="amount">{{ __('Amount') }}</label>
            <input type="text" id="amount" name="amount" value="{{ old('amount', $tradeBalance) }}" placeholder="0.00" required>
        </div>

        <!-- Expiry Time -->
        <div class="input-single">
            <label for="parameter">{{ __('Expiry Time') }}</label>
            <div class="toggle-buttons">
                @foreach($parameters as $parameter)
                    <label class="btn-toggle">
                        <input type="radio" name="parameter_id" value="{{ $parameter->id }}" required>
                        <span>{{ $parameter->time . ' ' . \App\Enums\Trade\TradeParameterUnit::getName($parameter->unit) }}</span>
                    </label>
                @endforeach
            </div>
        </div>

        <!-- Profit Card -->
        <div class="profit-card">
            <p>{{ __('Profit') }}</p>
            <div class="percent">
                <span id="profit_amount">+0.00</span>
                <sub> / {{ getArrayValue($setting->commissions_charge, 'binary_trade_commissions', 0) }} %</sub>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="d-flex justify-content-center align-items-center gap-3">
            <button type="submit" name="volume" value="{{ \App\Enums\Trade\TradeVolume::HIGH->value }}" class="i-btn btn--md btn--success capsuled w-100">{{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::HIGH->value)) }} <i class="bi bi-arrow-up"></i></button>
            <button type="submit" name="volume" value="{{ \App\Enums\Trade\TradeVolume::LOW->value }}" class="i-btn btn--md btn--danger capsuled w-100">{{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::LOW->value)) }} <i class="bi bi-arrow-down"></i></button>
        </div>
    </form>
</div>

--}}

<style>
    .toggle-buttons {
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
    }

    .btn-toggle {
        background-color: rgba(234, 125, 24, 0.4);
        color: white;
        border-radius: 3px;
        padding: 3px 3px;
        cursor: pointer;
        user-select: none;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    .btn-toggle input {
        display: none;
    }

    .btn-toggle span {
        display: block;
    }

    .btn-toggle input:checked + span {
        background-color: #fe710d;
    }

    /* Mobile responsiveness */
    @media (max-width: 768px) {
        .btn-toggle {
            flex: 1 0 30%; /* Adjust width as needed */
            text-align: center;
            padding: 10px;
        }

        .input-single input, .input-single select {
            width: 100%;
            padding: 10px;
        }

        .d-flex.justify-content-center.align-items-center.gap-3 {
            flex-direction: column;
            gap: 10px;
        }

        .i-btn {
            width: 100%;
            padding: 10px;
        }
    }
</style>
