@php
    $totalProfit = 0;
    $totalLoss = 0;
    $sumProfitDifference = 0.0;
    $sumLossDifference = 0.0;

    foreach($tradeLogs as $tradeLog) {
        $priceWas = $tradeLog->original_price;
        $resultPrice = $tradeLog->meta['result_price'] ?? $tradeLog->result_price;
        $difference = $resultPrice - $priceWas;

        if ($tradeLog->outcome == \App\Enums\Trade\TradeOutcome::WIN->value) {
            $totalProfit++;
            $sumProfitDifference += abs(number_format($difference, 6, '.', ''));
        } elseif ($tradeLog->outcome == \App\Enums\Trade\TradeOutcome::LOSE->value) {
            $totalLoss++;
            $sumLossDifference += abs(number_format($difference, 6, '.', ''));
        }
    }

    $result = number_format($sumProfitDifference - $sumLossDifference, 6, '.', '');
    $resultFormatted = number_format(abs($result), 6, '.', '');
    $resultSign = $result >= 0 ? 'text-success' : 'text-danger';
    $resultPrefix = $result >= 0 ? '+' : '-';
    $sumProfitDifferenceFormatted = number_format($sumProfitDifference, 6, '.', '');
    $sumLossDifferenceFormatted = number_format($sumLossDifference, 6, '.', '');
@endphp

<div class="card-container">
    <div class="card">
        <div class="card-body">
            <h7 class="card-title">{{ __('Total Profit Trades:') }}</h7>
            <p class="card-text text-success">{{ $totalProfit }}</p>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <h7 class="card-title">{{ __('Total Loss Trades:') }}</h7>
            <p class="card-text text-danger">{{ $totalLoss }}</p>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <h7 class="card-title">{{ __('Profit:') }}</h7>
            <p class="card-text text-success">{{ getCurrencySymbol() }}{{ $sumProfitDifferenceFormatted }}</p>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <h7 class="card-title">{{ __('Loss:') }}</h7>
            <p class="card-text text-danger">{{ getCurrencySymbol() }}{{ $sumLossDifferenceFormatted }}</p>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <h7 class="card-title">{{ __('Result (Profit/Loss):') }}</h7>
            <p class="card-text {{ $resultSign }}">{{ getCurrencySymbol() }}{{ $resultPrefix }}{{ $resultFormatted }}</p>
        </div>
    </div>
</div>



<div class="trade-table scroll-design dark--table">
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>{{ __('Initiated At') }}</th>
                    <th>{{ __('Trade Amount') }}</th>
                    <th>{{ __('Volume') }}</th>
                    <th>{{ __('Price Was') }}</th>
                    <th>{{ __('Result Price') }}</th>
                    <th>{{ __('Difference') }}</th>
                    <th>{{ __('Outcome') }}</th>
                </tr>
            </thead>
            <tbody>
            @forelse($tradeLogs as $tradeKey => $tradeLog)
                @php
                    $priceWas = $tradeLog->original_price;
                    $resultPrice = $tradeLog->meta['result_price'] ?? $tradeLog->result_price;
                    $difference = $resultPrice - $priceWas;
                    $differenceFormatted = number_format(abs($difference), 6);
                    $isProfit = $tradeLog->outcome == \App\Enums\Trade\TradeOutcome::WIN->value;
                    $isDraw = $tradeLog->outcome == \App\Enums\Trade\TradeOutcome::DRAW->value;
                    $isInitiated = $tradeLog->outcome == \App\Enums\Trade\TradeOutcome::INITIATED->value;
                @endphp
                <tr>
                    <td data-label="Initiated At">{{ diffForHumans($tradeLog->created_at) }}</td>
                    <td data-label="Amount">{{ getCurrencySymbol() }}{{ shortAmount($tradeLog->amount) }}</td>
                    <td data-label="Volume">
                        <span class="i-badge {{ \App\Enums\Trade\TradeVolume::getColor($tradeLog->volume) }}">
                            {{ \App\Enums\Trade\TradeVolume::getName($tradeLog->volume) }}
                        </span>
                    </td>
                    <td data-label="Price">{{ getCurrencySymbol() }}{{ number_format($priceWas, 6) }}</td>
                    <td data-label="Result Price">{{ getCurrencySymbol() }}{{ number_format($resultPrice, 6) }}</td>
                    <td data-label="Difference">
                        @if($isInitiated)
                            {{ __('N/A') }}
                        @else
                            <span class="{{ $isProfit ? 'text-success' : ($isDraw ? 'text-purple' : 'text-danger') }}">
                                {{ $isProfit ? '+' : ($isDraw ? '' : '-') }}{{ getCurrencySymbol() }}{{ $differenceFormatted }}
                            </span>
                        @endif
                    </td>
                    <td data-label="Outcome">
                        <span class="i-badge {{ \App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome) }}">
                            {{ \App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome) }}
                        </span>
                    </td>
                </tr>
            @empty
                <tr>
                    <td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </div>
</div>

<style>
.card-container {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin-bottom: 1rem;
}

.card {
    flex: 1;
    min-width: 200px;
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 0.25rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.card-body {
    padding: 1rem;
}
</style>
