@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
        <div class="row">
            <div class="col-lg-12">
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title">{{ __($setTitle) }}</h4>
                    </div>

                    <div class="row g-4">
                        @foreach($cryptoCurrency as $key => $crypto)
                            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                                <div class="i-card1-sm card-style linear-bg rounded-3">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h5 class="title text--purple mb-0">{{ $crypto->pair }}</h5>
                                        <div class="avatar--sm bg--purple">
                                            <img src="{{ $crypto->file }}" class="avatar--sm" alt="{{ __('Crypto-Image') }}">
                                        </div>
                                    </div>

                                    <div class="card-info text-center">
                                        <ul class="user-card-list w-100">
                                            <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                                                <span class="fw-bold">{{ __('Price') }}</span>
                                                <span class="fw-bold text--dark">${{ getArrayValue($crypto->meta, 'current_price') }}</span>
                                            </li>
                                            <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                                                <span class="fw-bold">{{ __('Market Cap') }}</span>
                                                <span class="fw-bold text--dark">{{ getArrayValue($crypto->meta, 'market_cap') }}</span>
                                            </li>
                                            <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                                                <span class="fw-bold">{{ __('Daily High') }}</span>
                                                <span class="fw-bold text--dark">{{ getArrayValue($crypto->meta, 'high_24h') }} %</span>
                                            </li>
                                            <li class="d-flex align-items-center justify-content-between gap-3">
                                                <span class="fw-bold">{{ __('Daily Low') }}</span>
                                                <span class="fw-bold text--dark">{{ getArrayValue($crypto->meta, 'low_24h') }} %</span>
                                            </li>
                                        </ul>
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.binary', $crypto->crypto_id) }}" class="i-btn btn--sm btn--primary-outline capsuled">{{ __('Trade') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'practice_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.practice', $crypto->crypto_id) }}" class="i-btn btn--sm btn--lite--secondary capsuled">{{ __('Practice') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') != \App\Enums\Status::ACTIVE->value && getArrayValue($setting->system_configuration, 'practice_trade.value') != \App\Enums\Status::ACTIVE->value)
                                            <span>{{ __('N/A') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    
                    <div class="mt-4">{{ $cryptoCurrency->links() }}</div>
                </div>
            </div>
        </div>
    </div>
@endsection






{{--@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
        <div class="row">
            <div class="col-lg-12">
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title">{{ __($setTitle) }}</h4>
                    </div>

                    <div class="table-container">
                        <table id="myTable" class="table">
                            <thead>
                                <tr>
                                    <th scope="col">{{ __('Pair') }}</th>
                                    <th scope="col">{{ __('Price') }}</th>
                                    <th scope="col">{{ __('Market Cap') }}</th>
                                    <th scope="col">{{ __('Daily High') }}</th>
                                    <th scope="col">{{ __('Daily Low') }}</th>
                                    <th scope="col">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($cryptoCurrency as $key => $crypto)
                                <tr>
                                    <td data-label="{{ __('Pair') }}">
                                        <div class="name d-flex align-items-center justify-content-md-start justify-content-end gap-lg-3 gap-2">
                                            <div class="icon">
                                                <img src="{{ $crypto->file }}" class="avatar--sm" alt="{{ __('Crypto-Image') }}">
                                            </div>
                                            <div class="content">
                                                <h6 class="fs-14">{{ $crypto->pair }}</h6>
                                                <span class="fs-13 text--light">{{ $crypto->name }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td data-label="{{ __('Price') }}">
                                        ${{ getArrayValue($crypto->meta, 'current_price') }}
                                    </td>
                                    <td data-label="{{ __('Market Cap') }}">
                                        {{ getArrayValue($crypto->meta, 'market_cap') }}
                                    </td>
                                    <td data-label="{{ __('Daily High') }}">
                                        {{ getArrayValue($crypto->meta, 'high_24h') }} %
                                    </td>
                                    <td data-label="{{ __('Daily Low') }}">
                                        {{ getArrayValue($crypto->meta, 'low_24h') }} %
                                    </td>
                                    <td data-label="{{ __('Action') }}">
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.binary', $crypto->crypto_id) }}" class="i-btn btn--sm btn--primary-outline capsuled">{{ __('Trade') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'practice_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.practice', $crypto->crypto_id) }}" class="i-btn btn--sm btn--lite--secondary capsuled">{{ __('Practice') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') != \App\Enums\Status::ACTIVE->value && getArrayValue($setting->system_configuration, 'practice_trade.value') != \App\Enums\Status::ACTIVE->value)
                                            <span>{{ __('N/A') }}</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">{{ $cryptoCurrency->links() }}</div>
                </div>
            </div>
        </div>
    </div>
@endsection --}}

{{--
@extends('layouts.user')
@section('content')
<div class="main-content" data-simplebar>
    <div class="row">
        <div class="col-lg-12">

                <!-- Crypto Currency Table -->
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title">{{ __($setTitle) }}</h4>
                    </div>

                    <div class="table-container">
                        <table id="myTable" class="table">
                            <thead>
                                <tr>
                                    <th scope="col">{{ __('Pair') }}</th>
                                    <th scope="col">{{ __('Price') }}</th>
                                    <th scope="col">{{ __('Market Cap') }}</th>
                                    <th scope="col">{{ __('Daily High') }}</th>
                                    <th scope="col">{{ __('Daily Low') }}</th>
                                    <th scope="col">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($cryptoCurrency as $key => $crypto)
                                <tr>
                                    <td data-label="{{ __('Pair') }}">
                                        <div class="name d-flex align-items-center justify-content-md-start justify-content-end gap-lg-3 gap-2">
                                            <div class="icon">
                                                <img src="{{ $crypto->file }}" class="avatar--sm" alt="{{ __('Crypto-Image') }}">
                                            </div>
                                            <div class="content">
                                                <h6 class="fs-14">{{ $crypto->pair }}</h6>
                                                <span class="fs-13 text--light">{{ $crypto->name }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td data-label="{{ __('Price') }}">
                                        ${{ getArrayValue($crypto->meta, 'current_price') }}
                                    </td>
                                    <td data-label="{{ __('Market Cap') }}">
                                        {{ getArrayValue($crypto->meta, 'market_cap') }}
                                    </td>
                                    <td data-label="{{ __('Daily High') }}">
                                        {{ getArrayValue($crypto->meta, 'high_24h') }} %
                                    </td>
                                    <td data-label="{{ __('Daily Low') }}">
                                        {{ getArrayValue($crypto->meta, 'low_24h') }} %
                                    </td>
                                    <td data-label="{{ __('Action') }}">
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.binary', $crypto->crypto_id) }}" class="i-btn btn--sm btn--primary-outline capsuled">{{ __('Trade') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'practice_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.practice', $crypto->crypto_id) }}" class="i-btn btn--sm btn--lite--secondary capsuled">{{ __('Practice') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') != \App\Enums\Status::ACTIVE->value && getArrayValue($setting->system_configuration, 'practice_trade.value') != \App\Enums\Status::ACTIVE->value)
                                            <span>{{ __('N/A') }}</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">{{ $cryptoCurrency->links() }}</div>
                </div>
                
                

            <!-- Cryptocurrency-Specific Statistics Section -->
            @foreach ($cryptoData as $data)
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title">{{ __('Today\'s Trading Statistics for') }} {{ $data['crypto']->name }}</h4>
                        <div class="d-flex align-items-center">
                            <img src="{{ $data['crypto']->file }}" class="avatar--md me-3" alt="{{ __('Crypto-Image') }}">
                            <h6>{{ $data['crypto']->name }}</h6>
                        </div>
                    </div>
                    <div class="d-flex flex-wrap gap-2">
                        <div class="i-card-sm primary--light shadow-none flex-grow-1 py-2 px-3 rounded-3">
                            <span class="d-block text-sm">{{ __('Total Trades') }}</span>
                            <h6 class="mt-1">{{ $data['totalTrades'] }}</h6>
                        </div>
                        <div class="i-card-sm primary--light shadow-none flex-grow-1 py-2 px-3 rounded-3">
                            <span class="d-block text-sm">{{ __('Total Trade Amount') }}</span>
                            <h6 class="mt-1">{{ getCurrencySymbol() }}{{ number_format($data['totalAmount'], 2) }}</h6>
                        </div>
                        <div class="i-card-sm primary--light shadow-none flex-grow-1 py-2 px-3 rounded-3">
                            <span class="d-block text-sm">{{ __('Total Virtual Purchase') }}</span>
                            <h6 class="mt-1">{{ number_format($data['totalVirtualPurchase'], 6) }}</h6>
                        </div>
                        <div class="i-card-sm primary--light shadow-none flex-grow-1 py-2 px-3 rounded-3">
                            <span class="d-block text-sm">{{ __('Virtual Profit (Total)') }}</span>
                            <h6 class="mt-1 text-success">{{ getCurrencySymbol() }}{{ number_format($data['totalVirtualProfit'], 2) }}</h6>
                        </div>
                        <div class="i-card-sm primary--light shadow-none flex-grow-1 py-2 px-3 rounded-3">
                            <span class="d-block text-sm">{{ __('Virtual Loss (Total)') }}</span>
                            <h6 class="mt-1 text-danger">{{ getCurrencySymbol() }}{{ number_format($data['totalVirtualLoss'], 2) }}</h6>
                        </div>
                        <div class="i-card-sm primary--light shadow-none flex-grow-1 py-2 px-3 rounded-3">
                            <span class="d-block text-sm">{{ __('Profit/Loss (Virtual Purchase)') }}</span>
                            <h6 class="mt-1 {{ $data['virtualProfitLoss'] >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ getCurrencySymbol() }}{{ number_format($data['virtualProfitLoss'], 2) }}
                            </h6>
                        </div>
                    </div>
                </div>
                
                <!-- Detailed Trade Logs Table -->
                <div class="table-container mb-4">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ __('Initiated At') }}</th>
                                <th>{{ __('Trade Amount') }}</th>
                                <th>{{ __('Trade Type') }}</th>
                                <th>{{ __('Price Was') }}</th>
                                <th>{{ __('Purchased Volume') }}</th>
                                <th>{{ __('Result Price') }}</th>
                                <th>{{ __('Profit/Loss') }}</th>
                                <th>{{ __('Outcome') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($data['detailedTradeLogs'] as $log)
                                <tr>
                                    <td>{{ $log['initiatedAt'] }}</td>
                                    <td>{{ getCurrencySymbol() }}{{ number_format($log['amount'], 2) }}</td>
                                    <td>
                                        <span class="i-badge {{ \App\Enums\Trade\TradeVolume::getColor($log['volume']) }}">
                                            {{ \App\Enums\Trade\TradeVolume::getName($log['volume']) }}
                                        </span>
                                    </td>
                                    <td>{{ getCurrencySymbol() }}{{ number_format($log['priceWas'], 2) }}</td>
                                    <td>{{ $log['purchasedVolume'] }}</td>
                                    <td>{{ getCurrencySymbol() }}{{ number_format($log['resultPrice'], 2) }}</td>
                                    <td>{{ $log['difference'] }}</td>
                                    <td class="{{ $log['outcomeClass'] }}">{{ $log['outcome'] }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8">{{ __('No trade logs available.') }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            @endforeach
        </div>
    </div>

        </div>
        </div>
    </div>
@endsection
--}}

