<?php $__env->startSection('title', $setTitle); ?>

<?php $__env->startSection('panel'); ?>
<section>
    <table class="table">
        <thead>
            <tr>
                <th><?php echo e(__('admin.table.name')); ?></th>
                <th><?php echo e(__('admin.table.email')); ?></th>
                <th><?php echo e(__('KYC Status')); ?></th>
                <th><?php echo e(__('Identity Information')); ?></th>
                <th><?php echo e(__('admin.table.action')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($user->full_name); ?></td>
                <td><?php echo e($user->email); ?></td>
                <td>
                    <span class="badge <?php echo e(\App\Enums\User\KycStatus::getColor($user->kyc_status)); ?>">
                        <?php echo e(\App\Enums\User\KycStatus::getName($user->kyc_status)); ?>

                    </span>
                </td>
                <td>
                    <button class="btn btn-info identity-info" data-meta="<?php echo e(json_encode($user->identity_information)); ?>">
                        <?php echo e(__('View')); ?>

                    </button>
                </td>
                <td>
                    <button class="btn btn-primary kyc_identity" data-id="<?php echo e($user->id); ?>">
                        <?php echo e(__('Update')); ?>

                    </button>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($users->links()); ?> <!-- Pagination links -->
</section>

<div class="modal fade" id="kycIdentityModal" tabindex="-1" aria-labelledby="credit-add-return" aria-hidden="true">
    <div class="modal-dialog modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Identity Verification Update')); ?></h5>
            </div>
            <form action="<?php echo e(route('admin.user.identity.update')); ?>" method="POST">
                <?php echo method_field('PUT'); ?>
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="kyc_status" class="form-label"> <?php echo e(__('KYC Status')); ?> <sup class="text--danger">*</sup></label>
                        <select class="form-select" name="kyc_status" id="kyc_status" required>
                            <?php $__currentLoopData = \App\Enums\User\KycStatus::cases(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status->value); ?>"><?php echo e(\App\Enums\User\KycStatus::getName($status->value)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="d-flex align-items-center gap-3">
                        <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"><?php echo e(__('admin.button.cancel')); ?></button>
                        <button type="submit" class="btn btn--primary btn--sm"><?php echo e(__('admin.button.save')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="identity-information" tabindex="-1" aria-labelledby="identityInformationLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('KYC Identity Information')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <ul class="modal-identity-list modal-pay-list"></ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('admin.button.closed')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
<script>
    "use strict";
    $(document).ready(function () {
        $('.kyc_identity').on('click', function () {
            const modal = $('#kycIdentityModal');
            const id = $(this).data('id');
            modal.find('input[name=id]').val(id);
            modal.modal('show');
        });

        $('.identity-info').on('click', function () {
            $('.modal-identity-list').empty();
            const modal = $('#identity-information');
            const meta = $(this).data('meta');

            if (meta && Object.keys(meta).length !== 0) {
                const identity = meta.identity || {};
                Object.keys(identity).forEach(key => {
                    const propertyName = key.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());
                    const propertyValue = identity[key];
                    const listItem = `<li>
                            <span>${propertyName}</span>
                            <span>${propertyValue}</span>
                          </li>`;
                    modal.find('.modal-identity-list').append(listItem);
                });
            } else {
                const listItem = `<li>
                        <span>No information available</span>
                      </li>`;
                modal.find('.modal-identity-list').append(listItem);
            }

            modal.modal('show');
        });
    });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/user/identity.blade.php ENDPATH**/ ?>