<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <h3 class="page-title"><?php echo e(__($setTitle)); ?></h3>
        <div class="i-card-sm">
            <div class="row">
                <div class="user-form">
                    <div class="col-lg-12 mb-4">
                        <form method="POST" action="<?php echo e(route('user.store.identity')); ?>">
                            <?php echo csrf_field(); ?>
                            <?php if(!is_null($kycConfigurations)): ?>
                                <div class="row">
                                    <?php $__currentLoopData = $kycConfigurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kycConfiguration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $fieldType = getArrayValue($kycConfiguration, 'field_type');
                                            $fieldLabel = getArrayValue($kycConfiguration, 'field_label');
                                            $isRequired = getArrayValue($kycConfiguration, 'is_required') == \App\Enums\Frontend\RequiredStatus::YES->value ? 'required' : '';
                                            $inputName = getInputName($fieldLabel);
                                        ?>
                                        <div class="col-lg-12">
                                            <div class="form-inner">
                                                <label for="<?php echo e($fieldLabel); ?>"><?php echo e(__($fieldLabel)); ?></label>
                                                <?php switch($fieldType):
                                                    case (\App\Enums\Frontend\InputField::TEXT->value): ?>
                                                        <input type="text" id="<?php echo e($fieldLabel); ?>" name="<?php echo e($inputName); ?>" placeholder="<?php echo e(__("Enter $fieldLabel")); ?>" <?php echo e($isRequired); ?>>
                                                        <?php break; ?>

                                                    <?php case (\App\Enums\Frontend\InputField::FILE->value): ?>
                                                        <input type="file" id="<?php echo e($fieldLabel); ?>" name="<?php echo e($inputName); ?>" placeholder="<?php echo e(__("Enter $fieldLabel")); ?>" <?php echo e($isRequired); ?>>
                                                        <?php break; ?>

                                                    <?php case (\App\Enums\Frontend\InputField::TEXTAREA->value): ?>
                                                        <textarea id="<?php echo e($fieldLabel); ?>" name="<?php echo e($inputName); ?>" <?php echo e($isRequired); ?>></textarea>
                                                        <?php break; ?>

                                                    <?php case (\App\Enums\Frontend\InputField::SELECT->value): ?>
                                                        <select id="<?php echo e($fieldLabel); ?>" name="<?php echo e($inputName); ?>" <?php echo e($isRequired); ?>>
                                                            <?php $__currentLoopData = getArrayValue($kycConfiguration, 'options'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($option); ?>"><?php echo e($option); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                            <div class="col-12">
                                <button type="submit" class="i-btn btn--primary btn--lg"><?php echo e(__('Save')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/kyc.blade.php ENDPATH**/ ?>